package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDatePickerProperties;

/**
 * 日期选择配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaDatePicker extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_DATEPICKER;

	/** 属性对象 */
	protected MetaDatePickerProperties properties = newProperties();

	/**
	 * 设置日期时间的显示格式
	 * 
	 * @param dateFormat
	 *            显示格式
	 */
	public void setDateFormat(String dateFormat) {
		this.properties.setDateFormat(dateFormat);
	}

	/**
	 * 获取日期时间的显示格式
	 * 
	 * @return 显示格式
	 */
	public String getDateFormat() {
		return this.properties.getDateFormat();
	}

	/**
	 * 设置是否仅保留日期部分
	 * 
	 * @param isOnlyDate
	 *            是否仅保留日期部分
	 */
	public void setOnlyDate(Boolean isOnlyDate) {
		this.properties.setOnlyDate(isOnlyDate);
	}

	/**
	 * 获取是否仅保留日期部分
	 * 
	 * @return 是否仅保留日期部分
	 */
	public Boolean isOnlyDate() {
		return this.properties.isOnlyDate();
	}

	/**
	 * 获取编辑样式
	 *
	 * @return 编辑样式，取值范围为{@link SelectEditType}
	 */
	public Integer getEditType() {
		return properties.getEditType();
	}

	/**
	 * 设置编辑样式
	 *
	 * @param editType 编辑样式，取值范围为{@link SelectEditType}
	 */
	public void setEditType(Integer editType) {
		properties.setEditType(editType);
	}

	/**
	 * 取得内容为空的时候的提示文本
	 *
	 * @return 内容为空的时候的提示文本
	 */
	public String getPromptText() {
		return this.properties.getPromptText();
	}

	/**
	 * 设置内容为空的时候的提示文本
	 *
	 * @param promptText 内容为空的时候的提示文本
	 */
	public void setPromptText(String promptText) {
		this.properties.setPromptText(promptText);
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.DATEPICKER;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaDatePicker newObject = (MetaDatePicker)super.clone();
		newObject.setProperties((MetaDatePickerProperties)properties.clone());

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDatePicker();
	}

	@Override
	public MetaDatePickerProperties getProperties() {
		return properties;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaDatePickerProperties) properties;
	}
	
	/**
	 * 生成新的属性对象
	 *
	 * @return 生成的新属性对象
	 */
	MetaDatePickerProperties newProperties() {
		return new MetaDatePickerProperties();
	}
}
