package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * 批量图片上传组件配置对象
 */
public class MetaBatchImageUploader extends MetaComponent {
	/** 上传文件大小,-1表示无限制*/
	private Integer maxSize = -1;
	
	private Integer maxCount = -1;
	
	public MetaBatchImageUploader() {
		super();
	}
	
	/**
	 * 获取限定文件上传大小的最大值
	 * @return 文件大小的最大值
	 */
	public Integer getMaxSize() {
		return maxSize;
	}

	/**
	 * 限定文件上传大小
	 * @param maxSize  文件大小
	 */
	public void setMaxSize(Integer maxSize) {
		this.maxSize = maxSize;
	}
	
	/**
	 * 获取限定文件上传限制数量
	 * @return 文件限制数量
	 */
	public Integer getMaxCount() {
		return maxCount;
	}

	/**
	 * 限定文件上传数量
	 * @param maxCount  文件数量
	 */
	public void setMaxCount(Integer maxCount) {
		this.maxCount = maxCount;
	}
	
	@Override
	public int getControlType() {
		return ControlType.BATCHIMAGEUPLOADER;
	}

	public static final String TAG_NAME = ControlType.STR_BATCHIMAGEUPLOADER;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaBatchImageUploader newObject = (MetaBatchImageUploader)super.clone();
		newObject.setMaxSize(maxSize);
		newObject.setMaxCount(maxCount);
		return newObject;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBatchImageUploader();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}

}
