package com.bokesoft.yigo.meta.form.component.container;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

/**
 * MetaSubDetail定义嵌入子明细配置
 * @author 王元和
 *
 */
public class MetaSubDetail extends MetaComponent {
	/** 嵌入子明细关联的表格的标识 */
	private String bindingGridKey = "";
	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_SUBDETAIL;
	/** 标签下的根,可能是面板或者其他组件*/
	private MetaComponent root = null;
	
	public MetaSubDetail() {
		super();
	}

	@Override
	public int getControlType() {
		return ControlType.SUBDETAIL;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getTagName() {
		return ControlType.STR_SUBDETAIL;
	}
	
	public MetaComponent getRoot(){
		return root;
	}
	
	public void setRoot(MetaComponent root) {
		this.root = root;
	}

	public DefSize getWidth() {
		return root == null ? null : root.getWidth();
	}
	
	public DefSize getHeight() {
		return root == null ? null : root.getHeight();
	}
	
	public DefSize getMinHeight() {
		return root == null ? null : root.getMinHeight();
	}
	
	@Override
	public int getComponentCount() {
		return root != null ? 1 : 0;
	}

	@Override
	public MetaComponent getComponent(int index) {
		return root;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new Object[] {
				root
		});
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject obj = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if( obj != null )
			return obj;
		MetaComponent control = MetaComponentFactory.getInstance().newComponent(tagName);
		control.preProcessMetaObject(env, doc, node, flag, runType);
		root = control;
		return control;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (root != null) {
			root.doPostProcess(flag, callback);
		} else {
			throw new MetaException(MetaException.ROOT_UNDEFINED, SimpleStringFormat.
					format(StringTable.getString(null, "", StringTable.RootUndefined), key));
		}
	}

	/**
	 * 设置绑定的表格的标识
	 * @param bindingGridKey 表格的标识
	 */
	public void setBindingGridKey(String bindingGridKey) {
		this.bindingGridKey = bindingGridKey;
	}
	
	/**
	 * 取得绑定的表格的标识
	 * @return 表格的标识
	 */
	public String getBindingGridKey() {
		return this.bindingGridKey;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaSubDetail newObject = (MetaSubDetail)super.clone();
		newObject.setBindingGridKey(bindingGridKey);
		newObject.setRoot(root == null ? null : (MetaComponent)root.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSubDetail();
	}
	
	@Override
	public void merge(MetaComponent meta) {
		super.merge(meta);
		
		MetaSubDetail metaSubDetail = (MetaSubDetail)meta;
		
		if( this.bindingGridKey == null ) {
			this.bindingGridKey = metaSubDetail.getBindingGridKey();
		}
	}

}
