package com.bokesoft.yigo.meta.form.component.chart;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaChartDataSource extends AbstractMetaObject {
	/** 绑定的数据源标识，如果来源于组件，则为组件的标识，如果来源于数据对象，则为表的标识 */
	private String bindingKey = "";
	private List<MetaSeries> seriesArray = null;
	private MetaCategory category = null;
	public MetaChartDataSource() {
		super();
		seriesArray = new ArrayList<MetaSeries>();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(seriesArray);
		if ( category != null ) {
			list.add(category);
		}
	}
	
	public static final String TAG_NAME = "ChartDataSource";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	public void setSeriesArray(List<MetaSeries> seriesArray) {
		this.seriesArray = seriesArray;
	}
	
	public List<MetaSeries> getSeriesArray() {
		return this.seriesArray;
	}
	
	public void setCategory(MetaCategory category) {
		this.category = category;
	}
	
	public MetaCategory getCategory() {
		return this.category;
	}
	
	public void setBindingKey(String bindingKey) {
		this.bindingKey = bindingKey;
	}
	
	public String getBindingKey() {
		return this.bindingKey;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaSeries.TAG_NAME.equals(tagName) ) {
			MetaSeries metaSeries = new MetaSeries();
			seriesArray.add(metaSeries);
			resultMetaObject = metaSeries;
		} else if ( MetaCategory.TAG_NAME.equals(tagName) ) {
			category = new MetaCategory();
			resultMetaObject = category;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaChartDataSource newObject = new MetaChartDataSource();
		newObject.setBindingKey(bindingKey);
		ArrayList<MetaSeries> newSeriesArray = new ArrayList<MetaSeries>();
		Iterator<MetaSeries> it = seriesArray.iterator();
		MetaSeries series = null;
		while ( it.hasNext() ) {
			series = it.next();
			newSeriesArray.add((MetaSeries)series.clone());
		}
		newObject.setSeriesArray(newSeriesArray);
		newObject.setCategory(category == null ? null : (MetaCategory)category.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaChartDataSource();
	}

}
