package com.bokesoft.yigo.meta.form.component.bar;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericCompositeCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaTreeMenuItemCollection extends GenericCompositeCollection {
	/** 菜单项标识 */
	private String key = "";
	/** 菜单项名称 */
	private String caption = "";
	/** 菜单项图标 */
	private String icon = "";
	
	@Override
	public int getCompositeType() {
		return MetaTreeMenuItem.MenuItemCollection;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	public void setKey(String key) {
		this.key = key;
	}
	
	public String getKey() {
		return this.key;
	}
	
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	public String getCaption() {
		return this.caption;
	}
	
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	public String getIcon() {
		return this.icon;
	}

	public static final String TAG_NAME = "TreeMenuItemCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaTreeMenuItem.TAG_NAME.equals(tagName) ) {
			MetaTreeMenuItem metaItem = new MetaTreeMenuItem();
			this.add(metaItem);
			resultMetaObject = metaItem;
		} else if ( MetaTreeMenuItemCollection.TAG_NAME.equals(tagName) ) {
			MetaTreeMenuItemCollection metaItemCollection = new MetaTreeMenuItemCollection();
			this.add(metaItemCollection);
			resultMetaObject = metaItemCollection;
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaTreeMenuItemCollection newObject = (MetaTreeMenuItemCollection)super.clone();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setIcon(icon);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTreeMenuItemCollection();
	}

}
