package com.bokesoft.yigo.meta.form.component.bar;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

public class MetaMenuBar extends MetaComponent {
	private MetaMenuItemCollection itemCollection = null;
	@Override
	public int getControlType() {
		return ControlType.MENUBAR;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		if ( itemCollection != null ) {
			list.add(itemCollection);
		}
	}
	
	public static final String TAG_NAME = ControlType.STR_MENUBAR;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	public void setItemCollection(MetaMenuItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}
	
	public MetaMenuItemCollection getItemCollection() {
		return this.itemCollection;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaMenuItemCollection.TAG_NAME.equals(tagName) ) {
			itemCollection = new MetaMenuItemCollection();
			resultMetaObject = itemCollection;
		} else {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMenuBar newObject = (MetaMenuBar)super.clone();
		newObject.setItemCollection(itemCollection == null ? null : (MetaMenuItemCollection)itemCollection.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMenuBar();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

}
