package com.bokesoft.yigo.meta.form.component;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaFormat extends AbstractMetaObject implements IPropertyMerger<MetaFormat>{
	/** 水平对齐 ，因为控件默认值不同，默认值为-1的时候，每个控件运用自己的默认值*/
	private Integer hAlign = -1;
	/** 垂直对齐 */
	private Integer vAlign = VAlignment.CENTER;
	/** 前景色,格式为#AABBCC，默认值为空 */
	private String foreColor = "";
	/** 背景色,格式为#AABBCC，默认值为空 */
	private String backColor = "";
	/** 高亮背景色 */
	private String highlightBackColor = "";
	/** 字体 */
	private MetaFont font = null;
	
	public MetaFormat() {
		super();
	}
	
	public void setForeColor(String foreColor) {
		this.foreColor = foreColor;
	}
	
	public String getForeColor() {
		return this.foreColor;
	}
	
	public void setBackColor(String backColor) {
		this.backColor = backColor;
	}
	
	public String getBackColor() {
		return this.backColor;
	}
	
	public void setHighlightBackColor(String highlightBackColor) {
		this.highlightBackColor = highlightBackColor;
	}
	
	public String getHighlightBackColor() {
		return this.highlightBackColor;
	}
	
	public void setFont(MetaFont font) {
		this.font = font;
	}
	
	public MetaFont getFont() {
		return this.font;
	}
	
	public Integer getHAlign() {
		return hAlign;
	}

	public void setHAlign(Integer hAlign) {
		this.hAlign = hAlign;
	}

	public Integer getVAlign() {
		return vAlign;
	}

	public void setVAlign(Integer vAlign) {
		this.vAlign = vAlign;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( font != null ) {
			list.add(font);
		}
	}

	public static final String TAG_NAME = "Format";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaFont.TAG_NAME.equals(tagName) ) {
			font = new MetaFont();
			resultMetaObject = font;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFormat newObject = new MetaFormat();
		newObject.setForeColor(foreColor);
		newObject.setBackColor(backColor);
		newObject.setHighlightBackColor(highlightBackColor);
		newObject.setHAlign(hAlign);
		newObject.setVAlign(vAlign);
		newObject.setFont(font == null ? null : (MetaFont)font.clone());

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFormat();
	}
	
	public boolean isDefault() {
		return hAlign == -1 && 
			   vAlign == VAlignment.CENTER && 
			   foreColor.isEmpty() && 
			   backColor.isEmpty() && 
			   highlightBackColor.isEmpty() &&
			   font == null;
	}

	@Override
	public void merge(MetaFormat meta) {
		if( this.hAlign == -1 ) {
			this.hAlign = meta.getHAlign();
		}
		if( this.vAlign == -1 ) {
			this.vAlign = meta.getVAlign();
		}
		if( this.foreColor == null ) {
			this.foreColor = meta.getForeColor();
		}
		if( this.backColor == null ) {
			this.backColor = meta.getBackColor();
		}
		if( this.highlightBackColor == null ) {
			this.highlightBackColor = meta.getHighlightBackColor();
		}
		
		MetaFont metaFont = meta.getFont();
		if( metaFont != null ) {
			if( this.font == null ) {
				this.font = (MetaFont) metaFont.clone();
			} else {
				this.font.merge(metaFont);
			}
		}
	}
}
