package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaFormRelationCollection定义表单数据源关系集合
 * @author wangyh
 *
 */
public class MetaFormRelationCollection extends GenericNoKeyCollection<MetaFormRelation>{

	/** 配置文件中对应节点的标签名称 */
	public static final String TAG_NAME = "FormRelationCollection";
	
	/**
	 * 获取FormKey对应的DataObjectKey
	 * @param formKey 表单标识
	 * @return 表单标识对应的数据对象标识
	 */
	public String getDataObjectKey(String formKey){
		for(MetaFormRelation relation : this){
			if(relation.getFormKey().equals(formKey)){
				return relation.getDataObjectKey();
			}
		}
		return null;
	}
	
	/**
	 * 获取DataObjectKey对应的FormKey
	 * @param dataObjectKey 数据对象标识
	 * @return 数据对象标识对象的表单标识
	 */
	public String getFormKey(String dataObjectKey){
		for(MetaFormRelation relation : this){
			if(relation.getDataObjectKey().equals(dataObjectKey)){
				return relation.getFormKey();
			}
		}
		return null;
	}
	
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaFormRelation.TAG_NAME.equals(tagName)) {
			resultMetaObject = new MetaFormRelation();
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
			add((MetaFormRelation) resultMetaObject);
		} 

		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFormRelationCollection();
	}

}
