package com.bokesoft.yigo.meta.form;

import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.anim.MetaAnimCollection;
import com.bokesoft.yigo.meta.form.anim.MetaAnimItem;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.mobiledef.MetaWatermark;

public class MetaFormMergeHandler {

	public static MetaMobileDef getMobileDefInProject(IMetaFactory metaFactory, String projectKey) {
		MetaMobileDef projectMobileDef = null;
		try {
			projectMobileDef = metaFactory.getMobileDef(projectKey);
		} catch (Throwable e) {
			e.printStackTrace();
		}
		return projectMobileDef;
	}

	public static MetaMobileDef getMobileDefInSolution(IMetaFactory metaFactory) {
		MetaMobileDef solutionMobileDef = null;
		try {
			solutionMobileDef = metaFactory.getMobileDef(null);
		} catch (Throwable e) {
			e.printStackTrace();
		}
		return solutionMobileDef;
	}
	
	/**
	 * 合并属性前的预先处理
	 */
	public static void  preMergeMetaObject(IMetaFactory metaFactory, MetaForm metaForm) throws Throwable{
		if (metaForm == null)
			return;
		String projectKey = metaForm.getProjectKey();
		MetaMobileDef projectMobileDef = getMobileDefInProject(metaFactory, projectKey);
		MetaMobileDef solutionMobileDef = getMobileDefInSolution(metaFactory);
		
		if (metaForm.getMetaNavigation() == null) {
			//如果metaForm上的NavigationBar不存在的情况下，需要判断mobileDef上是否有定义，
			//有的话，需要提前设置一个MetaNavigationBar，以便之后的dopostProcess处理。
			if(projectMobileDef != null) {
				
			}
			MetaNavigationBar projectNavigationBar = projectMobileDef == null ? null : projectMobileDef.getNavigationBar();
			MetaNavigationBar solutionNavigationBar = solutionMobileDef == null ? null : solutionMobileDef.getNavigationBar();
			if (projectNavigationBar != null || solutionNavigationBar != null) {
				MetaNavigationBar metaNav = new MetaNavigationBar();
				metaNav.mergePropertiesWithMobileDef(projectNavigationBar, solutionNavigationBar);
				metaForm.setNavigation(new MetaNavigationBar());
			}
		}
	}

	/**
	 * 处理MetaMobileDef中同MetaForm公用的属性，将MobileDef中定义的属性按需赋值给MetaForm，
	 * 以便于MetaForm进行JSON序列化后，传递给前台程序。
	 */
	public static void mergeCommonPropertiesWithMobileDef(IMetaFactory metaFactory, MetaForm metaForm) {
		if (metaForm == null)
			return;
		String projectKey = metaForm.getProjectKey();
		MetaMobileDef projectMobileDef = getMobileDefInProject(metaFactory, projectKey);
		MetaMobileDef solutionMobileDef = getMobileDefInSolution(metaFactory);

		// 处理hasNavigationBar属性
		String hasNavigationBar = metaForm.isHasNavigationBar();
		if (hasNavigationBar.isEmpty()) {
			if (projectMobileDef != null) {
				hasNavigationBar = projectMobileDef.getHasNavigationBar();
			}
		}
		if (hasNavigationBar.isEmpty()) {
			if (solutionMobileDef != null) {
				hasNavigationBar = solutionMobileDef.getHasNavigationBar();
			}
		}
		metaForm.setHasNavigationBar(hasNavigationBar);

		// 处理disableKeyboard属性
		Boolean disableKeyboard = metaForm.isDisableKeyboard();
		if (disableKeyboard == null) {
			if (projectMobileDef != null) {
				disableKeyboard = projectMobileDef.isDisableKeyboard();
			}
		}
		if (disableKeyboard == null) {
			if (solutionMobileDef != null) {
				disableKeyboard = solutionMobileDef.isDisableKeyboard();
			}
		}
		metaForm.setDisableKeyboard(disableKeyboard);

		// 处理animCollection属性
		MetaAnimCollection animCollection = metaForm.getAnimCollection();
		MetaAnimCollection projectAnimCollection = projectMobileDef == null ? null : projectMobileDef.getAnimCollection();
		MetaAnimCollection solutionAnimCollection = solutionMobileDef == null ? null : solutionMobileDef.getAnimCollection();
		
		if(animCollection == null){
			animCollection = new MetaAnimCollection();
		}
		if(projectAnimCollection != null && projectAnimCollection.size() > 0){
			for(int i=0;i<projectAnimCollection.size();i++){
				MetaAnimItem item = projectAnimCollection.get(i);
				animCollection.add(item);
			}
		}
		if(solutionAnimCollection != null && solutionAnimCollection.size() > 0){
			for(int i=0;i<solutionAnimCollection.size();i++){
				MetaAnimItem item = solutionAnimCollection.get(i);
				animCollection.add(item);
			}
		}
		metaForm.setAnimCollection(animCollection.size() == 0 ? null : animCollection);
		
		//处理fullScreenType属性
		int fullScreenType = metaForm.getFullScreenType();
		if (fullScreenType == -1) {
			if(projectMobileDef != null){
				fullScreenType = projectMobileDef.getFullscreenType();
			}
			if (fullScreenType == -1) {
				if(solutionMobileDef != null){
					fullScreenType = solutionMobileDef.getFullscreenType();
				}
			}
		}
		metaForm.setFullScreenType(fullScreenType);
		
		//处理statusBarColor属性
		String statusBarColor = metaForm.getStatusBarColor();
		if (statusBarColor == null) {
			if(projectMobileDef != null){
				statusBarColor = projectMobileDef.getStatusBarColor();
			}
			if (statusBarColor == null) {
				if(solutionMobileDef != null){
					statusBarColor = solutionMobileDef.getStatusBarColor();
				}
			}
		}
		metaForm.setStatusBarColor(statusBarColor);
		
		//处理水印
		MetaWatermark watermark = metaForm.getWatermark();
		if (watermark == null) {
			if(projectMobileDef != null){
				watermark = projectMobileDef.getWatermark();
			}
			if (watermark == null) {
				if(solutionMobileDef != null){
					watermark = solutionMobileDef.getWatermark();
				}
			}
		}
		metaForm.setWatermark(watermark);
		
	}
}
