package com.bokesoft.yigo.meta.form;

import java.io.Serializable;
import java.util.HashMap;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;

public class MetaFormBindingMap implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private HashMap<String, HashMap<String, MetaComponent>> comMap = null;
	private HashMap<String, HashMap<String, MetaGridCell>> cellMap = null;
	private HashMap<String, HashMap<String, MetaListViewColumn>> lvcMap = null;
	private HashMap<String, HashMap<String, MetaEditViewColumn>> evcMap = null;

	public MetaFormBindingMap() {
		this.comMap = StringHashMap.newInstance();
		this.cellMap = StringHashMap.newInstance();
		this.lvcMap = StringHashMap.newInstance();
		this.evcMap = StringHashMap.newInstance();
	}

	public void buildBinding(String tableKey, String columnKey, IPropertiesElement ele) {
		switch (ele.getTagName()) {
		case MetaGridCell.TAG_NAME:
			buildCellBinding(tableKey, columnKey, (MetaGridCell) ele);
			break;
		case MetaListViewColumn.TAG_NAME:
			buildLVColumnBinding(tableKey, columnKey, (MetaListViewColumn) ele);
			break;
		case MetaEditViewColumn.TAG_NAME:
			buildEVColumnBinding(tableKey, columnKey, (MetaEditViewColumn) ele);
			break;
		default:
			buildComponentBinding(tableKey, columnKey, (MetaComponent) ele);;
		}
	}
	
	public void clear() {
		this.comMap.clear();
		this.cellMap.clear();
		this.lvcMap.clear();
		this.evcMap.clear();
	}
	
	private void buildComponentBinding(String tableKey,String columnKey,MetaComponent component){	
		HashMap<String, MetaComponent> map = this.comMap.get(tableKey);
		if( map == null ) {
			map = StringHashMap.newInstance();
			this.comMap.put(tableKey, map);
		}
		map.put(columnKey, component);
	}
	
	private void buildCellBinding(String tableKey, String columnKey, MetaGridCell metaCell) {
		HashMap<String, MetaGridCell> map = this.cellMap.get(tableKey);
		if ( map == null ) {
			map = StringHashMap.newInstance();
			this.cellMap.put(tableKey, map);
		}
		map.put(columnKey, metaCell);
	}
	
	private void buildLVColumnBinding(String tableKey, String columnKey, MetaListViewColumn metaColumn) {
		HashMap<String, MetaListViewColumn> map = this.lvcMap.get(tableKey);
		if ( map == null ) {
			map = StringHashMap.newInstance();
			this.lvcMap.put(tableKey, map);
		}
		map.put(columnKey, metaColumn);
	}
	
	private void buildEVColumnBinding(String tableKey, String columnKey, MetaEditViewColumn metaColumn) {
		HashMap<String, MetaEditViewColumn> map = this.evcMap.get(tableKey);
		if ( map == null ) {
			map = StringHashMap.newInstance();
			this.evcMap.put(tableKey, map);
		}
		map.put(columnKey, metaColumn);
	}
	
	/**
	 * 根据数据绑定关系取得单元格定义
	 * 
	 * @param tableKey 表标识
	 * @param columnKey 列标识
	 * @return 单元格定义
	 */
	public MetaGridCell getCellByDataBinding(String tableKey,String columnKey) {
		HashMap<String, MetaGridCell> map = this.cellMap.get(tableKey);
		return map == null ? null : map.get(columnKey);
	}
	
	/**
	 * 根据数据绑定关系取得组件
	 * @param tableKey 表标识
	 * @param columnKey 列标识
	 * @return 组件定义
	 */
	public MetaComponent getComponentByDataBinding(String tableKey, String columnKey) {
		HashMap<String, MetaComponent> map = this.comMap.get(tableKey);
		return map == null ? null : map.get(columnKey);
	}
	
	/**
	 * 根据数据绑定关系取得ListView列
	 * @param tableKey 表标识
	 * @param columnKey 列标识
	 * @return ListView列定义
	 */
	public MetaListViewColumn getLvColumnByDataBinding(String tableKey, String columnKey) {
		HashMap<String, MetaListViewColumn> map = this.lvcMap.get(tableKey);
		return map == null ? null : map.get(columnKey);
	}
	
	public MetaEditViewColumn getEvColumnByDataBinding(String tableKey, String columnKey) {
		HashMap<String, MetaEditViewColumn> map = this.evcMap.get(tableKey);
		return map == null ? null : map.get(columnKey);
	}
}
