package com.bokesoft.yigo.meta.flatcanvas.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.flatcanvas.common.Point;

/**
 * 平面图工具类
 * 
 * @author chenbinbin
 *
 */
public class FCUtil {

	/**
	 * 多点坐标字符串转化为数组
	 * 
	 * @param sPoints 多点坐标字符, ("x1,y1,x2,y2,x3,y3 ...")
	 * @return 点位置数组
	 */
	public static Double[] getPoints(String sPoints) {
		String[] as = StringUtil.split(sPoints, ",");
		Double[] points = new Double[as.length];
		for (int i=0; i<as.length; i++) {
			points[i] = TypeConvertor.toDouble(as[i]);
		}
		return points;
	}
	
	/**
	 * 点列表转化为字符串
	 * 
	 * @param lstPoints 多点列表
	 * @return 多点字符串
	 */
	public static String points2String(List<Point> lstPoints) {
		StringBuilder builder = new StringBuilder("");
		for (int i=0; i<=lstPoints.size()-1; i++) {
			builder.append(lstPoints.get(i).x)
				.append(",")
				.append(lstPoints.get(i).y)
				.append(i == lstPoints.size() - 1 ? "" : ",");
		}
		return builder.toString();
	}
	
	/**
	 * 颜色转字符格式
	 * 
	 * @param red 颜色的R值
	 * @param green 颜色的G值
	 * @param blue 颜色的B值
	 * @return 颜色的字符串格式
	 */
    public static String colorValueToHex(double red, double green, double blue) {
        return String.format((Locale)null, "#%02x%02x%02x",
                             Math.round(red * 255),
                             Math.round(green * 255),
                             Math.round(blue * 255));
    }
    
    /**
     * 多个列表合并
     * 
     * @param pars 多个列表对象
     * @param <T> 子对象类
     * 
     * @return 合并后的列表
     */
    @SafeVarargs
	public static <T> List<T> concatList(List<T> ... pars) {
    	List<T> newList = new ArrayList<T>();
    	for(List<T> list : pars) {
    		for(T item: list) {
    			newList.add(item);
    		}
    	}
    	return newList;
    }

}
