package com.bokesoft.yigo.meta.flatcanvas.convertor.json;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;

/**
 * 配置节点对象的json节点表述
 * 
 * @author chenbinbin
 *
 */
public class JsonNode implements INode {
	
	private String tagName = "";
	
	private Object element =  null;
	
	public JsonNode(String tagName, Object element) {
		this.tagName = tagName;
		this.element = element;
	}

	@Override
	public void setAttribute(String key, Object value) {
		if (element instanceof JSONObject) {
			((JSONObject) element).put(key, value);
		}
	}

	@Override
	public void appendChild(INode node) {
		Object child = node.getData();
		if (element instanceof JSONArray) {
			((JSONArray) element).put(child);   //..add(child);
		} else {
			setAttribute(node.getTagName(), child);
		}
	}

	@Override
	public Object getData() {
		return element;
	}

	@Override
	public String getTagName() {
		return tagName;
	}

}
