package com.bokesoft.yigo.meta.exceltemplate;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExcelWorkbook extends GenericNoKeyCollection<MetaExcelSheet> {
	public static final String TAG_NAME = "Workbook";
	
	/** Excel模板的名称 */
	private String caption = "";
	
	/** Excel模板的标识,唯一.*/
	private String key = "";
	
	/** 后台分页表单需要重新载入数据*/
	private Boolean needLoadData = false;
	
	/** 对应表单的FormKey*/
	private String formKey = "";
	
	private MetaExcelSheet sheet = null;
	
	private Boolean needResetCellIndex = false;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject metaObject = null;
		if (MetaExcelSheet.TAG_NAME.equals(tagName)) {
			MetaExcelSheet metaExcelSheet = new MetaExcelSheet();
			metaObject = metaExcelSheet;
			this.add(metaExcelSheet);
		}
		return metaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExcelWorkbook();
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Boolean isNeedLoadData() {
		return needLoadData;
	}

	public void setNeedLoadData(Boolean needLoadData) {
		this.needLoadData = needLoadData;
	}
	
	public Boolean isNeedResetCellIndex() {
		return this.needResetCellIndex;
	}
	
	public void setNeedRestCellIndex(Boolean needResetCellIndex) {
		this.needResetCellIndex = needResetCellIndex;
	}

	public String getFormKey() {
		return formKey;
	}

	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}

	public MetaExcelSheet getSheet() {
		return sheet;
	}

	public void setSheet(MetaExcelSheet sheet) {
		this.sheet = sheet;
	}
	
	/**
	 * 获取到用于关联明细的单元格
	 * 
	 * @return
	 */
	public MetaExcelCell getDetailLinkedCell() {
		for (MetaExcelSheet sheet : getList()) {
			for(MetaExcelRow row : sheet.getRows()) {
				for (MetaExcelCell cell : row.getList()) {
					if (cell.getSourceType() == ExcelTemplateCellType.Field && cell.isDetailLinked()) {
						return cell;
					}
				}
			}
		}
		return null;
	}
}
