package com.bokesoft.yigo.meta.exceltemplate;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExcelRow extends GenericNoKeyCollection<MetaExcelCell> {
	public static final String TAG_NAME = "Row";

	/** 行高 */
	private Integer height = 35;
	/** 行类型 */
	private Integer type = ExcelTemplateRowType.Fix;
	/** 行号*/
	private Integer rowIndex = -1;
	/** 表格标志*/
	private String gridKey = "";
	/** 类型为明细时 对应的数据源标志*/
	private String tableKey = "";
	/** 分组字段*/
	private String groupDefination = "";
	/** 分组级别*/
	private Integer groupLevel = 0;
	/** 分组行位置*/
	private String groupPosition = "";
	/** 头部分组行的个数*/
	private Integer groupHeadRowCount = 0;
	/** 尾部分组行的个数*/
	private Integer groupTailRowCount = 0;
	
	public MetaExcelRow() {
		super();
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaExcelCell.TAG_NAME)) {
			resultMetaObject = new MetaExcelCell();
		}
		resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		add((MetaExcelCell) resultMetaObject);
		return resultMetaObject;
	}

	/**
	 * 取得行高
	 * 
	 * @return 行高
	 */
	public Integer getHeight() {
		return height;
	}

	/**
	 * 设置行高
	 * 
	 * @param height
	 *            行高
	 */
	public void setHeight(Integer height) {
		this.height = height;
	}

	/**
	 * 取得行类型
	 * 
	 * @return 行类型
	 */
	public Integer getType() {
		return type;
	}

	/**
	 * 设置行类型
	 * 
	 * @param type
	 *            行类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	public Integer getRowIndex() {
		return rowIndex;
	}
	
	public void setRowIndex(Integer rowIndex) {
		this.rowIndex = rowIndex;
	}
	
	public String getTableKey() {
		return tableKey;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	public String getGridKey() {
		return gridKey;
	}

	public void setGridKey(String gridKey) {
		this.gridKey = gridKey;
	}
	
	public String getGroupDefination() {
		return groupDefination;
	}

	public void setGroupDefination(String groupDefination) {
		this.groupDefination = groupDefination;
	}

	public Integer getGroupLevel() {
		return groupLevel;
	}

	public void setGroupLevel(Integer groupLevel) {
		this.groupLevel = groupLevel;
	}

	public String getGroupPosition() {
		return groupPosition;
	}

	public void setGroupPosition(String groupPosition) {
		this.groupPosition = groupPosition;
	}

	public Integer getGroupHeadRowCount() {
		return groupHeadRowCount;
	}

	public void setGroupHeadRowCount(Integer groupHeadRowCount) {
		this.groupHeadRowCount = groupHeadRowCount;
	}

	public Integer getGroupTailRowCount() {
		return groupTailRowCount;
	}

	public void setGroupTailRowCount(Integer groupTailRowCount) {
		this.groupTailRowCount = groupTailRowCount;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExcelRow();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaExcelRow newRow = (MetaExcelRow) super.clone();
		newRow.setHeight(height);
		newRow.setType(type);
		newRow.setRowIndex(rowIndex);
		newRow.setGroupLevel(groupLevel);
		newRow.setGroupPosition(groupPosition);
		newRow.setGroupHeadRowCount(groupHeadRowCount);
		newRow.setGroupTailRowCount(groupTailRowCount);
		newRow.setGroupDefination(groupDefination);
		return newRow;
	}
	
	public boolean isDefalut(){
		return  rowIndex == -1 &&
				height == 35 &&
				type == ExcelTemplateRowType.Fix &&
				tableKey.isEmpty() &&
				gridKey.isEmpty() &&
				groupLevel == 0 &&
				groupDefination.isEmpty() &&
				groupPosition.isEmpty() &&
				groupHeadRowCount == 0 &&
				groupTailRowCount ==0 &&
				this.size() == 0 ;
	}

}
