package com.bokesoft.yigo.meta.enhance;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExtImportService extends GenericKeyCollection<MetaImportService> implements IElementMerge<MetaExtImportService> {
	public static final String TAG_NAME = "ExtImportService";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(MetaImportService.TAG_NAME.equals(tagName)){
			MetaImportService service = new MetaImportService();
			service.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(service);
			resultMetaObject = service;
		} else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No MetaObject defined for " + tagName);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtImportService();
	}

	@Override
	public MetaExtImportService toMerge(MetaExtImportService obj) {
		if (obj != null) {
			Iterator<MetaImportService> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaImportService metaImportService = (MetaImportService) iterator.next();
				if (containsKey(metaImportService.getKey())) {
					throw new MetaException(MetaException.REPEAT_EXT_IMPORT_SERVICE_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatExtImportServiceDefined),
									metaImportService.getKey()));
				}
				add(metaImportService);
			}
		}
		return this;
	}
}
