package com.bokesoft.yigo.meta.enhance;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExtDataProcess extends GenericKeyCollection<MetaDataProcess> implements IElementMerge<MetaExtDataProcess>{

	public static final String TAG_NAME = "ExtDataProcess";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(MetaDataProcess.TAG_NAME.equals(tagName)){
			MetaDataProcess dataProcess = new MetaDataProcess();
			dataProcess.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(dataProcess);
			resultMetaObject = dataProcess;
		} else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No MetaObject defined for " + tagName);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtDataProcess();
	}

	@Override
	public MetaExtDataProcess toMerge(MetaExtDataProcess obj) {
		if (obj != null) {
			Iterator<MetaDataProcess> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaDataProcess metaDataProcess = (MetaDataProcess) iterator.next();
				if (containsKey(metaDataProcess.getKey())) {
					throw new MetaException(MetaException.REPEAT_EXT_SERVICE_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatExtServiceDefined),
									metaDataProcess.getKey()));
				}
				add(metaDataProcess);
			}
		}
		return this;
	}

}
