package com.bokesoft.yigo.meta.diff;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
/**
 * 记录差异节点添加顺序
 * @author 陈瑞
 *
 */
public class MetaIndex extends KeyPairMetaObject {
	/**
	 * 节点标识
	 */
	private String key = null;
	
	/**
	 * 节点位置
	 */
	private Integer index = -1;
	
	public static final String TAG_NAME = "Index";
	
	public MetaIndex() {
	}
	
	public MetaIndex(String key, Integer index) {
		super();
		this.key = key;
		this.index = index;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaIndex o = new MetaIndex();
		o.setKey(key);
		o.setIndex(index);
		return o;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaIndex();
	}

	public Integer getIndex() {
		return index;
	}

	public void setIndex(Integer index) {
		this.index = index;
	}

}
