package com.bokesoft.yigo.meta.diff;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaDiffList extends GenericKeyCollection<MetaDiffProfile> implements IElementMerge<MetaDiffList>{

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "DiffList";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if ( MetaDiffProfile.TAG_NAME.equals(tagName) ) {
			MetaDiffProfile metaFormProfile = new MetaDiffProfile();
			metaFormProfile.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaFormProfile);
			child = metaFormProfile;
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public MetaDiffList toMerge(MetaDiffList obj) {
		if (obj != null) {
			Iterator<MetaDiffProfile> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaDiffProfile metaDiffProfile = (MetaDiffProfile) iterator.next();
				if (containsKey(metaDiffProfile.getKey())) {
					throw new MetaException(MetaException.REPEAT_FORM_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatFormDefined),
									metaDiffProfile.getProject().getKey(), metaDiffProfile.getKey()));
				}
				add(metaDiffProfile);
			}
		}
		return this;
	}

}
