package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaTableSplit定义批量持久化时的数据拆分方向，即如何将一个表中的数据拆分到不同数据对象。
 * <p>拆分的依据包括以下属性：
 * <ul>
 * <li>OID所在字段的列标识，用于如何载入数据对象
 * <li>明细OID所在字段的列标识，在保存的数据为明细数据的情况下用于标识明细行OID字段所在的列标识
 * </ul>
 * @author wangyh
 *
 */
public class MetaTableSplit extends KeyPairMetaObject {
	/** 表标识 */
	private String key = "";
	/** OID所在的列标识 */
	private String OIDColumnKey = "";
	/** 明细行OID所在的列标识 */
	private String DetailOIDColumnKey = "";
	
	public MetaTableSplit() {
		super();
	}

	@Override
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置表标识
	 * @param key 表标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 设置OID所在的列标识
	 * @param OIDColumnKey OID所在的列标识
	 */
	public void setOIDColumnKey(String OIDColumnKey) {
		this.OIDColumnKey = OIDColumnKey;
	}
	
	/**
	 * 取得OID所在的列标识
	 * @return OID所在的列标识
	 */
	public String getOIDColumnKey() {
		return this.OIDColumnKey;
	}
	
	/**
	 * 设置明细行OID所在的列标识
	 * @param DetailOIDColumnKey 列标识
	 */
	public void setDetailOIDColumnKey(String DetailOIDColumnKey) {
		this.DetailOIDColumnKey = DetailOIDColumnKey;
	}
	
	/**
	 * 取得明细行OID所在的列标识
	 * @return 列标识
	 */
	public String getDetailOIDColumnKey() {
		return this.DetailOIDColumnKey;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "TableSplit";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTableSplit newObject = (MetaTableSplit)newInstance();
		newObject.setKey(key);
		newObject.setOIDColumnKey(OIDColumnKey);
		newObject.setDetailOIDColumnKey(DetailOIDColumnKey);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTableSplit();
	}

}
