package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaStatusTriggerCollection定义数据对象的状态触发器集合
 * @author 王元和
 *
 */
public class MetaStatusTriggerCollection extends GenericNoKeyCollection<MetaStatusTrigger> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "StatusTriggerCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaStatusTrigger.TAG_NAME.equals(tagName) ) {
			MetaStatusTrigger statusTrigger = new MetaStatusTrigger();
			this.add(statusTrigger);
			resultMetaObject = statusTrigger;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStatusTriggerCollection();
	}

}
