package com.bokesoft.yigo.meta.dataobject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * MetaStatusTrigger为数据对象的状态触发器，定义数据对象到达某个状态时需要执行的操作。比如数据对象审批完成后发送邮件。
 * @author 王元和
 *
 */
public class MetaStatusTrigger extends MetaBaseScript {
	/** 状态标识 */
	private String statusKey = "";
	public MetaStatusTrigger() {
		super(TAG_NAME);
	}

	public static final String TAG_NAME = "StatusTrigger";
	
	/**
	 * 设置状态标识
	 * @param statusKey 状态标识
	 */
	public void setStatusKey(String statusKey) {
		this.statusKey = statusKey;
	}
	
	/**
	 * 取得状态标识
	 * @return 状态标识
	 */
	public String getStatusKey() {
		return this.statusKey;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaStatusTrigger newObject = (MetaStatusTrigger)super.clone();
		newObject.setStatusKey(statusKey);
		return newObject;
	}
	
	@Override
	public AbstractMetaObject newInstance(){
		return new MetaStatusTrigger();
	}
}
