package com.bokesoft.yigo.meta.datamigration;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaDataMigrationList extends GenericKeyCollection<MetaDataMigrationProfile> implements IElementMerge<MetaDataMigrationList> {
	private MetaDataMigrationSourceTreeMap map = null;
	/**迁移目标数据对象与对应迁移关系集合的映射*/
	private MetaDataMigrationSourceTreeMap tgtMap = null;
	public MetaDataMigrationList() {
		super();
		map = new MetaDataMigrationSourceTreeMap();
		tgtMap = new MetaDataMigrationSourceTreeMap();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	@Override
	public MetaDataMigrationProfile add(MetaDataMigrationProfile element) {
		super.add(element);
		String objectKey = element.getSrcDataObjectKey();
		MetaDataMigrationSourceTree tree = map.get(objectKey);
		if ( tree == null ) {
			tree = new MetaDataMigrationSourceTree(objectKey);
			map.add(new WrapperMetaDataMigrationSourceTree(tree));
		}
		tree.add(element);
		
		String tgtObjectKey = element.getTgtDataObjectKey();
		MetaDataMigrationSourceTree tgtTree = tgtMap.get(tgtObjectKey);
		if (tgtTree == null) {
			tgtTree = new MetaDataMigrationSourceTree(tgtObjectKey);
			tgtMap.add(new WrapperMetaDataMigrationSourceTree(tgtTree));
		}
		tgtTree.add(element);
		
		return element;
	}
	
	/**
	 * 根据源取得所有迁移关系
	 * @param objectKey 源数据对象标识
	 * @return 源数据对象标识
	 */
	public MetaDataMigrationSourceTree getTree(String objectKey) {
		MetaDataMigrationSourceTree tree = map.get(objectKey);
		return tree;
	}
	
	/**
	 * 根据目标取得所有的迁移关系
	 * @param objectKey 目标数据对象标识
	 * @return 以指定数据对象为目标的所有源迁移关系集合
	 */
	public MetaDataMigrationSourceTree getTgtTree(String objectKey) {
		return tgtMap.get(objectKey);
	}

	public static final String TAG_NAME = "DataMigrationList";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}
	
	public TreeSet<String> getTgtObjectKeys(){
		TreeSet<String> set = new TreeSet<>();
		for (MetaDataMigrationSourceTree tree : tgtMap) {
			set.add(tree.getKey());
		}
		return set;
	}

	@Override
	public MetaDataMigrationList toMerge(MetaDataMigrationList obj) {
		if (obj != null) {
			Iterator<MetaDataMigrationProfile> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaDataMigrationProfile metaDataMigrationProfile = (MetaDataMigrationProfile) iterator.next();
				if (containsKey(metaDataMigrationProfile.getKey())) {
					throw new MetaException(MetaException.REPEAT_DATA_MIGRATION_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatDataMigrationDefined),
									metaDataMigrationProfile.getProject().getKey(), metaDataMigrationProfile.getKey()));
				}
				add(metaDataMigrationProfile);
			}
		}
		return this;
	}

}
