package com.bokesoft.yigo.meta.datamap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaDataMapList extends GenericKeyCollection<MetaDataMapProfile> implements IElementMerge<MetaDataMapList> {

	public static final String TAG_NAME = "DataMapList";

	private StringHashMap<ArrayList<String>> tgtDMListMap = new StringHashMap<ArrayList<String>>();

	private StringHashMap<ArrayList<String>> srcDMListMap = new StringHashMap<ArrayList<String>>();

	/**
	 * 查询所有指向给定KEY的数据对象的数据映射关系
	 * 
	 * @param dataObjectKey 数据对象标识
	 * @return 所有目标为dataObjectKey的所有数据映射关系的集合
	 */
	public ArrayList<String> getDMListByTgtDataObjectKey(String dataObjectKey) {
		ArrayList<String> list = tgtDMListMap.get(dataObjectKey);
		if (list == null) {
			list = new ArrayList<String>();
			tgtDMListMap.put(dataObjectKey, list);
			for (MetaDataMapProfile dm : this) {
				if (dm.getTgtDataObjectKey().equalsIgnoreCase(dataObjectKey))
					list.add(dm.getKey());
			}
		}

		return list;
	}
	
	/**
	 * 取得所有源为指定key的映射关系的集合
	 * @param dataObjectKey 数据对象标识
	 * @return 所有源为dataObjectKey的数据映射关系的集合
	 */
	public ArrayList<String> getDMListBySrcDataObjectKey(String dataObjectKey){
		ArrayList<String> list = srcDMListMap.get(dataObjectKey);
		if (list == null) {
			list = new ArrayList<String>();
			srcDMListMap.put(dataObjectKey, list);
			for (MetaDataMapProfile dm : this) {
				if (dm.getSrcDataObjectKey().equalsIgnoreCase(dataObjectKey))
					list.add(dm.getKey());
			}
		}
		return list;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return null;
	}

	@Override
	public MetaDataMapList toMerge(MetaDataMapList obj) {
		if (obj != null) {
			Iterator<MetaDataMapProfile> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaDataMapProfile metaDataMapProfile = (MetaDataMapProfile) iterator.next();
				if (containsKey(metaDataMapProfile.getKey())) {
					throw new MetaException(MetaException.REPEAT_DATA_MAP_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatDataMapDefined),
									metaDataMapProfile.getProject().getKey(), metaDataMapProfile.getKey()));
				}
				add(metaDataMapProfile);
			}
		}
		return this;
	}

}
