package com.bokesoft.yigo.meta.calendar;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 日期
 * 
 * @author 刘翔翔
 *
 */
public class MetaDay extends AbstractMetaObject {

	public static final String TAG = "Day";

	/** 年,-1代表每年 */
	private Integer year = -1;

	/** 月,-1代表每月 */
	private Integer month = -1;

	/** 日期 */
	private Integer day = -1;

	/** 是否为调休日，即原本是节假日需要调整为工作日 */
	private Boolean offDay = false;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDay();
	}

	public Integer getYear() {
		return year;
	}

	public void setYear(Integer year) {
		this.year = year;
	}

	public Integer getMonth() {
		return month;
	}

	public void setMonth(Integer month) {
		this.month = month;
	}

	public Integer getDay() {
		return day;
	}

	public void setDay(Integer day) {
		this.day = day;
	}

	public Boolean isOffDay() {
		return offDay;
	}

	public void setOffDay(Boolean offDay) {
		this.offDay = offDay;
	}
}
