package com.bokesoft.yigo.meta.bpm.total;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.AbstractBPMNoKeyCollection;

public class MetaProcessMapCollection extends AbstractBPMNoKeyCollection<MetaProcessMap> {

	public static final String TAG_NAME = "ProcessMapCollection";

	private String defaultStartAction = "";

	// 方便查询的hash结构
	/** 是否已经初始化 */
	private boolean init = false;

	/** 和表单绑定的信息 */
	private StringHashMap<MetaProcessMap> formMap = null;

	/** 和数据对象绑定的信息 */
	private StringHashMap<MetaProcessMap> dataobjectMap = null;

	/**
	 * 执行初始化
	 */
	private void init() {
		formMap = new StringHashMap<MetaProcessMap>();
		dataobjectMap = new StringHashMap<MetaProcessMap>();

		for (MetaProcessMap pm : this) {
			if (pm.getType() == ProcessMapType.Form)
				formMap.put(pm.getKey(), pm);
			else
				dataobjectMap.put(pm.getKey(), pm);
		}
		init = true;
	}

	public MetaProcessMap getFormMapInfo(String formKey) {
		if (!init)
			init();
		return formMap.get(formKey);
	}

	public MetaProcessMap getDataobjectMapInfo(String dataobjectKey) {
		if (!init)
			init();
		return dataobjectMap.get(dataobjectKey);
	}

	@Override
	protected MetaProcessMap createChildMetaElement(String tagName) {
		MetaProcessMap child = null;
		if (tagName.equalsIgnoreCase(MetaProcessMap.TAG_NAME))
			child = new MetaProcessMap();
		return child;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProcessMapCollection();
	}

	public String getDefaultStartAction() {
		return defaultStartAction;
	}

	public void setDefaultStartAction(String defaultStartAction) {
		this.defaultStartAction = defaultStartAction;
	}
	
	public StringHashMap<MetaProcessMap> getFormMap(){
		if (!init)
			init();
		return formMap;
	}
	
	public StringHashMap<MetaProcessMap> getDataObjectMap(){
		if (!init)
			init();
		return dataobjectMap;
	}

}
