package com.bokesoft.yigo.meta.bpm.process.perm;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaVisiblePerm extends GenericKeyCollection<MetaVisiblePermItem> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public static final String TAG_NAME = "VisiblePerm";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaVisiblePermItem.TAG_NAME.equals(tagName)) {
			MetaVisiblePermItem permItem = new MetaVisiblePermItem();
			permItem.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(permItem);
			resultMetaObject = permItem;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaVisiblePerm();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		JSONArray visiblePermArray = new JSONArray();
		Iterator<Entry<String, MetaVisiblePermItem>> it = this.elementMap.entrySet().iterator();
		Entry<String, MetaVisiblePermItem> entry = null;
		MetaVisiblePermItem visiblePerm = null;
		while ( it.hasNext() ) {
			entry = it.next();
			visiblePerm = entry.getValue();
			visiblePermArray.put(visiblePerm.toJSON());
		}
		obj.put("items", visiblePermArray);
		
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		if ( json.has("items") ) {
			JSONArray visiblePermArray = json.getJSONArray("items");
			for ( int i = 0, size = visiblePermArray.length(); i<size; ++i ) {
				JSONObject visiblePermObj = visiblePermArray.getJSONObject(i);
				MetaVisiblePermItem visiblePermItem = new MetaVisiblePermItem();
				visiblePermItem.fromJSON(visiblePermObj);
				this.add(visiblePermItem);
			}
		}
	}

}
