package com.bokesoft.yigo.meta.bpm.process.monitor;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaNodeScope extends GenericKeyCollection<MetaNodeDef> {
	public final static String TAG_NAME = "NodeScope";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaNodeDef.TAG_NAME.equals(tagName)) {
			MetaNodeDef nodeDef = new MetaNodeDef();
			nodeDef.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(nodeDef);
			resultMetaObject = nodeDef;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNodeScope();
	}

	public boolean contain(String processKey, String nodeKey) {
		MetaNodeDef nodeDef = get(processKey);
		if (nodeDef != null) {
			if (!StringUtil.isBlankOrNull(nodeDef.getNodeKeys())) {
				String[] keys = StringUtil.split(nodeDef.getNodeKeys(), ",");
				for (String item : keys) {
					if (item.equalsIgnoreCase(nodeKey)) {
						return true;
					}
				}
			}
		}
		return false;
	}
}
