package com.bokesoft.yigo.meta.bpm.process.attribute.parameter;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaStaticParameter extends MetaBasicParameter {
	
public static final String TAG_NAME = "StaticParameter";
	
	/** 参数的数据类型 */
	protected int dataType = -1;

	/** 参数的来源公式 */
	protected String formula = "";
	
	/** 参数key */
	protected String fieldKey = "";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaStaticParameter metaStaticParameter = (MetaStaticParameter)newInstance();
		metaStaticParameter.setDataType(dataType);
		metaStaticParameter.setFormula(formula);
		metaStaticParameter.setFieldKey(fieldKey);
		return metaStaticParameter;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStaticParameter();
	}
	
	
	public int getDataType() {
		return dataType;
	}

	public void setDataType(int dataType) {
		this.dataType = dataType;
	}

	public String getFormula() {
		return formula;
	}

	public void setFormula(String formula) {
		this.formula = formula;
	}

	public String getFieldKey() {
		return fieldKey;
	}

	public void setFieldKey(String fieldKey) {
		this.fieldKey = fieldKey;
	}

	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		obj.put("dataType", dataType);
		obj.put("formula", formula);
		obj.put("fieldKey", fieldKey);
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		dataType = json.optInt("dataType");
		formula = json.optString("formula");
		fieldKey = json.optString("fieldKey");
	}
}
