package com.bokesoft.yigo.meta.bpm.process.attribute;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 数据映射节点其中关于一个数据映射的设置
 * 
 * @author 刘翔翔
 *
 */
public class MetaBillDataMapInfo extends AbstractMetaObject {

	public static final String TAG_NAME = "BillDataMapInfo";

	/** 数据映射的KEY */
	private String dataMapKey = "";
	/** 名称 */
	private String caption = "";
	/** 中间层自动映射产生数据时是否启动流程 */
	private Boolean autoStart = false;
	/** 自动映射且自动启动流程时，目标单据的视图KEY */
	private String formKey;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaBillDataMapInfo newDataMapInfo = (MetaBillDataMapInfo) newInstance();
		newDataMapInfo.setDataMapKey(dataMapKey);
		newDataMapInfo.setCaption(caption);
		newDataMapInfo.setAutoStart(autoStart);
		newDataMapInfo.setFormKey(formKey);
		return newDataMapInfo;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBillDataMapInfo();
	}

	public String getDataMapKey() {
		return dataMapKey;
	}

	public void setDataMapKey(String dataMapKey) {
		this.dataMapKey = dataMapKey;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public Boolean isAutoStart() {
		return autoStart;
	}

	public void setAutoStart(Boolean autoStart) {
		this.autoStart = autoStart;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		obj.put("data-map-key", dataMapKey);
		obj.put("caption", caption);
		obj.put("auto-start", autoStart);

		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		this.dataMapKey = json.optString("data-map-key");
		this.caption = json.optString("caption");
		this.autoStart = json.optBoolean("auto-start");
	}

	public String getFormKey() {
		return formKey;
	}

	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
}
