package com.bokesoft.yigo.meta.bpm.migration;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.datamap.source.FieldType;

/**
 * 流程附属数据迁移的迁移字段
 * 
 * @author 刘翔翔
 *
 */
public class MetaDMField extends KeyPairMetaObject {

	public static final String TAG_NAME = "Field";

	/** 迁移字段的KEY */
	private String key;

	/** 来源字段的KEY */
	private String sourceFieldKey = "";

	/** 字段类型*/
	private Integer type = FieldType.FIELD;
	
	/** 常量值*/
	private String constValue = "";
	@Override
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDMField newField = (MetaDMField) newInstance();
		newField.setKey(key);
		newField.setSourceFieldKey(sourceFieldKey);
		return newField;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDMField();
	}

	public String getSourceFieldKey() {
		return sourceFieldKey;
	}

	public void setSourceFieldKey(String sourceFieldKey) {
		this.sourceFieldKey = sourceFieldKey;
	}

	public void setType(Integer type) {
		this.type = type;
	}
	
	public Integer getType() {
		return type;
	}
	
	public void setConstValue(String constValue) {
		this.constValue = constValue;
	}
	
	public String getConstValue() {
		return constValue;
	}
}
