package com.bokesoft.yigo.meta.bpm;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public abstract class AbstractBPMNoKeyCollection<T extends AbstractMetaObject> extends GenericNoKeyCollection<T> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		T child = createChildMetaElement(tagName);
		if (child != null) {
			child.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(child);
		}
		return child;
	}

	/**
	 * 根据标签的名称创建一个集合中的元素对象
	 * 
	 * @param tagName 节点标识
	 * @return 配置对象
	 */
	protected abstract T createChildMetaElement(String tagName);

}
