package com.bokesoft.yigo.meta.base;

import java.io.InputStream;
import java.net.URI;
import java.util.List;

import org.json.JSONObject;
import org.xml.sax.Attributes;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomSAXReader;
import com.bokesoft.yigo.common.dom.IDomSAXReaderListener;

public interface IMetaResolver {
	/**
	 * 资源resource是否采用绝对路径
	 * @return 是否采用绝对路径
	 */
	public boolean isListAbsolutePath();
	/**
	 * 读取资源
	 * @param resource 资源路径
	 * @param type 类型
	 * @return 资源的输入流
	 * @throws Exception 读取异常
	 */
	public InputStream read(String resource, int type) throws Exception;
	/**
	 * 获取资源的地址
	 * @param resource 资源路径
	 * @param type 类型
	 * @return 资源地址
	 * @throws Exception 异常
	 */
	public URI getURI(String resource, int type) throws Exception;
	/**
	 *	写入指定资源
	 * @param resource 资源路径
	 * @param data 二进制数据
	 * @return 是否写入成功
	 * @throws Exception 异常
	 */
	public boolean write(String resource, byte[] data) throws Exception;
	/**
	 * 获取资源的绝对路径
	 * @param resource 资源路径
	 * @return
	 */
	public String getPath(String resource);
	/**
	 * 获取目录下的资源列表
	 * @param resource 目录路径
	 * @param flag 文件过滤标识，一般通过文件名来过滤无关文件
	 * @param resources 资源列表
	 * @param names 资源名称集合
	 * @param flags 资源标识：true-为目录资源；false-为文件资源
	 * @return 资源列表的数目
	 * @throws Exception 异常
	 */
	public int listResource(String resource, String flag, List<String> resources, List<String> names, List<Boolean> flags) throws Exception;
	/**
	 * 获取资源路径分隔符，一般Unix/Linux为"/", Windows为"\\"
	 * @return 资源路径分隔符
	 */
	public char getSeparator();
	/**
	 * 获取xml文件的根元素信息
	 * @param resource 相对路径
	 * @param type 类型
	 * @return 根元素的属性信息：{"TagName":根元素名,"属性1":值1,"属性2":值2,...}
	 * @throws Exception 解析异常
	 */
	default public JSONObject readProfile(String resource, int type)throws Exception{
		JSONObject profileInfo = new JSONObject();
		DomSAXReader reader = new DomSAXReader(null, new IDomSAXReaderListener() {

			@Override
			public void startElement(Object parent, String resource, String uri, String localName, String qName,
					Attributes attributes) {
				
				profileInfo.put(MetaConstants.COMMON_TAG_NAME, qName.intern());
				for (int i = 0; i < attributes.getLength(); i++) {
					profileInfo.put(attributes.getQName(i).intern(), attributes.getValue(i).intern());
				}
			}

			@Override
			public void endElement(String uri, String localName, String qName) {
			}

			@Override
			public boolean stopParse(boolean startElement, String tagName) {
				return true;
			}

		});
		InputStream in = read(resource, 0);
		if(in == null){
			return null;
		}
		try {
			reader.start(in, resource);
		} catch (Throwable e) {
			LogSvr.getInstance().debug(resource, e);
			throw e;
		} finally {
			if (in != null) {
				in.close();
			}
		}
		return profileInfo;
	}
}
