package com.bokesoft.yigo.meta.archive;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ArchiveTimeType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 用来表示在一个字段上的归档条件的元数据
 * @author yuanye
 *
 */

public class MetaField extends GenericNoKeyCollectionWithKey<MetaParam> {

	public final static String TAG_NAME = "Field";
	
	/**
	 * 归档判断的字段名
	 */
	private String key = "";
	
	/**
	 * 判断类型
	 */
	private Integer conditionType= -1;
	
	/** 当类型为Time时，条件参数的时间类型*/
	private Integer dateType = ArchiveTimeType.DAY;
	
	public void setConditionType(Integer conditionType){
		this.conditionType = conditionType;
	}
	
	public Integer getConditionType(){
		return this.conditionType;
	}
	
	public void setKey(String key){
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return key;
	}
	
	public Integer getDateType() {
		return dateType;
	}

	public void setDateType(Integer dateType) {
		this.dateType = dateType;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaParam.TAG_NAME)) {
			resultMetaObject = new MetaParam();
			add((MetaParam) resultMetaObject);
		}
		
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaField();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaField newObj = (MetaField)super.clone();
		newObj.key = key;
		newObj.conditionType = conditionType;
		newObj.dateType = dateType;
		return newObj;
	}


}
