package com.bokesoft.yes.meta.process;

import java.util.Iterator;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaButton;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.MetaHyperLink;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;

public class MetaSubDetailProcess {
	private MetaForm metaForm;

	public MetaSubDetailProcess(MetaForm metaForm) {
		this.metaForm = metaForm;
	}

	public void process() {
		Iterator<MetaComponent> it = metaForm.getSubDetails().iterator();
		MetaSubDetail metaSub = null;
		while (it.hasNext()) {
			metaSub = (MetaSubDetail) it.next();
			String parentKey = metaSub.getBindingGridKey();
			if (parentKey == null || parentKey.isEmpty()) {
				throw new MetaException(MetaException.PARENT_GRID_NOT_FOUND, SimpleStringFormat.format(
						StringTable.getString(null, "", StringTable.ParentGridNotFound), metaForm.getKey(), parentKey));
			}
			MetaTableRow metaRow = metaForm.metaTableRowByKey(parentKey);
			if (metaRow != null && metaRow.getRowType() == RowType.Detail) {
				metaRow.setHasSubDetail(true);
				impl_processSubDetail4MobileList(metaSub.getRoot(), metaRow);
			} else {
				MetaComponent parent = metaForm.componentByKey(parentKey);
				if (parent instanceof MetaEditView) {
					((MetaEditView) parent).setHasSubDetail(true);
					impl_processSubDetail4MobileList(metaSub.getRoot(), parent);
				} else if (parent instanceof MetaTableView) {
					for (MetaTableRow row : ((MetaTableView) parent).getRows()) {
						row.setHasSubDetail(true);
						impl_processSubDetail4MobileList(metaSub.getRoot(), parent);
					}
				} else {
					MetaGrid parGrid = (MetaGrid) parent;
					parGrid.setHasSubDetail(true);
					impl_processSubDetail(metaSub.getRoot(), parGrid);
				}
			}
		}
	}

	private void impl_processSubDetail(MetaComponent rootCom, MetaGrid metaGrid) {
		if (rootCom.isPanel()) {
			MetaPanel metaPanel = (MetaPanel) rootCom;
			for (MetaComponent meta : metaPanel.getComponentArray()) {
				if (meta.getControlType() == ControlType.SUBDETAIL)
					continue;
				if (meta.isPanel()) {
					impl_processSubDetail(meta, metaGrid);
				} else {
					impl_processCom(meta, metaGrid);
				}
			}
			rootCom.setParentGridKey(metaGrid.getKey());
		} else {
			impl_processCom(rootCom, metaGrid);
		}
	}

	private void impl_processCom(MetaComponent meta, MetaGrid metaGrid) {
		String gridKey = metaGrid.getKey();
		if (meta.getControlType() != ControlType.GRID) {
			if (meta.hasDataBinding() && meta.getTableKey().equals(metaGrid.getTableKey())) {
				meta.setParentGridKey(gridKey);
			}
			String cellKey = meta.getBindingCellKey();
			MetaGridCell bindCell = null;
			if (cellKey != null && !cellKey.isEmpty()) {
				meta.setParentGridKey(gridKey);
				bindCell = metaForm.metaGridCellByKey(cellKey);
			}
			if (meta.isSubDetail()) {
				impl_processAttrs(meta, metaGrid, bindCell);
			}
		} else {
			meta.setParentGridKey(gridKey);
		}
	}

	private static void impl_processAttrs(MetaComponent meta, MetaGrid metaGrid, MetaGridCell bindCell) {
		MetaBaseScript onclick = null;
		switch (meta.getControlType()) {
			case ControlType.BUTTON:
				MetaButton metaButton = (MetaButton) meta;
				onclick = metaButton.getOnClick();
				if ((onclick == null || onclick.isEmpty()) && bindCell != null
						&& bindCell.getCellType() == ControlType.BUTTON) {
					MetaBaseScript script = ((MetaButtonProperties) bindCell.getProperties()).getOnClick();
					if (script != null) {
						metaButton.setOnClick((MetaBaseScript) script.clone());
					}
				}
				break;
			case ControlType.HYPERLINK:
				MetaHyperLink hyperLink = (MetaHyperLink) meta;
				onclick = hyperLink.getOnClick();
				if ((onclick == null || onclick.isEmpty()) && bindCell != null
						&& bindCell.getCellType() == ControlType.HYPERLINK) {
					MetaBaseScript script = ((MetaHyperLinkProperties) bindCell.getProperties()).getOnClick();
					if (script != null) {
						hyperLink.setOnClick((MetaBaseScript) script.clone());
					}
				}
				break;
			case ControlType.DICT:
				MetaDict metaDict = (MetaDict) meta;
				MetaItemFilterCollection filters = metaDict.getFilters();
				if ((filters == null || filters.size() == 0) && bindCell != null
						&& bindCell.getCellType() == ControlType.DICT) {
					MetaItemFilterCollection itemFilters = ((MetaDictProperties) bindCell.getProperties()).getFilters();
					if (itemFilters != null) {
						((MetaDictProperties) metaDict.getProperties())
								.setFilters((MetaItemFilterCollection) itemFilters.clone());
					}
				}
				break;
			default:
				break;
		}
	}

	private void impl_processSubDetail4MobileList(MetaComponent rootCom, MetaComponent parentCom) {
		if (rootCom.isPanel()) {
			MetaPanel metaPanel = (MetaPanel) rootCom;
			for (MetaComponent meta : metaPanel.getComponentArray()) {
				if (meta.getControlType() == ControlType.SUBDETAIL)
					continue;
				if (meta.isPanel()) {
					impl_processSubDetail4MobileList(meta, parentCom);
				} else {
					impl_processCom4MobileList(meta, parentCom);
				}
			}
			rootCom.setParentGridKey(parentCom.getKey());
		} else {
			impl_processCom4MobileList(rootCom, parentCom);
		}
	}

	private void impl_processCom4MobileList(MetaComponent meta, MetaComponent parentCom) {
		String key = parentCom.getKey();
		if (meta instanceof MetaTableView) {
			MetaTableView tableView = (MetaTableView) meta;
			for (MetaTableRow row : tableView.getRows()) {
				row.setParentGridKey(parentCom.getKey());
				impl_processSubDetail4MobileList(row.getRoot(), parentCom);
			}
		} else if (meta instanceof MetaEditView) {
			meta.setParentGridKey(parentCom.getKey());
		} else {
			if (meta.hasDataBinding() && meta.getTableKey().equals(parentCom.getTableKey())) {
				meta.setParentGridKey(key);
			}
			String cellKey = meta.getBindingCellKey();
			MetaComponent cellComponent = null;
			if (cellKey != null && !cellKey.isEmpty()) {
				meta.setParentGridKey(key);
				cellComponent = metaForm.metaDetailComponentByKey(cellKey);
			}
			if (meta.isSubDetail()) {
				int cellType;
				if (cellComponent instanceof MetaEditViewColumn) {
					cellType = ((MetaEditViewColumn) cellComponent).getColumnType();
				} else {
					cellType = meta.getControlType();
				}
				impl_processAttrs4MobileList(meta, parentCom, cellComponent, cellType);
			}
		}
	}

	private static void impl_processAttrs4MobileList(MetaComponent meta, MetaComponent parentCom,
													 MetaComponent bindCell, int cellType) {
		MetaBaseScript onclick = null;
		switch (meta.getControlType()) {
			case ControlType.BUTTON:
				MetaButton metaButton = (MetaButton) meta;
				onclick = metaButton.getOnClick();
				if ((onclick == null || onclick.isEmpty()) && bindCell != null && cellType == ControlType.BUTTON) {
					MetaBaseScript script = ((MetaButtonProperties) bindCell.getProperties()).getOnClick();
					if (script != null) {
						metaButton.setOnClick((MetaBaseScript) script.clone());
					}
				}
				break;
			case ControlType.HYPERLINK:
				MetaHyperLink hyperLink = (MetaHyperLink) meta;
				onclick = hyperLink.getOnClick();
				if ((onclick == null || onclick.isEmpty()) && bindCell != null && cellType == ControlType.HYPERLINK) {
					MetaBaseScript script = ((MetaHyperLinkProperties) bindCell.getProperties()).getOnClick();
					if (script != null) {
						hyperLink.setOnClick((MetaBaseScript) script.clone());
					}
				}
				break;
			case ControlType.DICT:
				MetaDict metaDict = (MetaDict) meta;
				MetaItemFilterCollection filters = metaDict.getFilters();
				if ((filters == null || filters.size() == 0) && bindCell != null && cellType == ControlType.DICT) {
					MetaItemFilterCollection itemFilters = ((MetaDictProperties) bindCell.getProperties()).getFilters();
					if (itemFilters != null) {
						((MetaDictProperties) metaDict.getProperties())
								.setFilters((MetaItemFilterCollection) itemFilters.clone());
					}
				}
				break;
			default:
				break;
		}
	}
}