package com.bokesoft.yes.meta.process;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.process.struct.ExprToken;
import com.bokesoft.yes.meta.process.struct.TokenIDUtil;
import com.bokesoft.yes.meta.process.struct.WildcardExprToken;
import com.bokesoft.yes.parser.LexDef;
import com.bokesoft.yes.parser.Lexer;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaUICalcExpr;
import com.bokesoft.yigo.meta.form.MetaUICalcExprCollection;
import com.bokesoft.yigo.meta.form.MetaUICheckRule;
import com.bokesoft.yigo.meta.form.MetaUICheckRuleCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowCollection;

public class MetaGridWildcardProcess {
	private MetaForm metaForm = null;
	public MetaGridWildcardProcess(MetaForm metaForm) {
		this.metaForm = metaForm;
	}
	
	public void process() {
		MetaUICalcExprCollection calcExprCollection = metaForm.getCalcExprCollection();
		if ( calcExprCollection != null ) {
			Iterator<MetaUICalcExpr> it = calcExprCollection.iterator();
			MetaUICalcExpr calcExpr = null;
			while ( it.hasNext() ) {
				calcExpr = it.next();
				String target = calcExpr.getTarget();
				MetaGrid grid = (MetaGrid)this.metaForm.componentByKey(target);
				extractCalcExpr(grid, calcExpr);
			}
		}
		
		MetaUICheckRuleCollection uiCheckRuleCollection = metaForm.getUICheckRuleCollection();
		if ( uiCheckRuleCollection != null ) {
			MetaUICheckRule checkRule = null;
			int size = uiCheckRuleCollection.size();
			for ( int i = size - 1; i>=0; --i ) {
				checkRule = uiCheckRuleCollection.get(i);
				String target = checkRule.getTarget();
				if ( target != null && !target.isEmpty()) {
					MetaGrid grid = (MetaGrid)this.metaForm.componentByKey(target);
					extractUICheckRule(grid, checkRule);
					uiCheckRuleCollection.remove(i);
				}
			}
		}
	}
	
	private void extractUICheckRule(MetaGrid grid, MetaUICheckRule checkRule) {
		MetaGridRowCollection rows = grid.getRowCollection();
		MetaGridColumnCollection columns = grid.getColumnCollection();
		int rowCount = rows.size();
		int columnCount = columns.size();
		
		String formula = checkRule.getContent();
		LinkedList<ExprToken> tokens = new LinkedList<ExprToken>();
		Lexer lex = new Lexer(formula);
		int id = lex.next();
		WildcardExprToken firstWildcard = null;
		while ( id != -1 ) {
			String fullLexValue = lex.getFullLexValue();
			String lexValue = fullLexValue == null ? lex.getLexValue() : fullLexValue;
			
			ExprToken t = this.packToken(id, lexValue, rowCount, columnCount);
			if ( t.isWildcard() && firstWildcard == null ) {
				firstWildcard = (WildcardExprToken)t;
			}
			tokens.add(t);
			
			id = lex.next();
		}
		
		if ( firstWildcard != null ) {
			int rowSize = firstWildcard.getRowSize();
			int columnSize = firstWildcard.getColumnSize();
			for ( int i = 0; i<columnSize; ++i ) {
				for ( int j = 0; j<rowSize; ++j ) {
					StringBuilder sb = new StringBuilder();
					Iterator<ExprToken> it = tokens.iterator();
					ExprToken et = null;
					String first = null;
					while ( it.hasNext() ) {
						et = it.next();
						if ( et.isWildcard() ) {
							WildcardExprToken wet = (WildcardExprToken)et;
							int column = wet.getColumn(i);
							int row = wet.getRow(j);
							if ( first == null ) {
								first = TokenIDUtil.toColumnID(column) + Integer.toString(row);
							}
							sb.append(TokenIDUtil.toColumnID(column));
							sb.append(Integer.toString(row));
						} else {
							sb.append(et.getLexValue());
						}
					}
					String tmp = sb.toString();
					MetaGridCell metaCell = metaForm.metaGridCellByKey(first);
					if ( metaCell != null ) {
						metaCell.ensureDataBinding().setCheckRule(tmp);
						metaCell.ensureDataBinding().setErrorInfo(checkRule.getDescription());
					}
				}
			}
		}
	}
	
	
	private void extractCalcExpr(MetaGrid grid, MetaUICalcExpr expr) {
		MetaGridRowCollection rows = grid.getRowCollection();
		MetaGridColumnCollection columns = grid.getColumnCollection();
		int rowCount = rows.size();
		int columnCount = columns.size();
		
		String formula = expr.getDefaultFormulaValue();
		LinkedList<ExprToken> tokens = new LinkedList<ExprToken>();
		Lexer lex = new Lexer(formula);
		int id = lex.next();
		WildcardExprToken firstWildcard = null;
		while ( id != -1 ) {
			String fullLexValue = lex.getFullLexValue();
			String lexValue = fullLexValue == null ? lex.getLexValue() : fullLexValue;
			
			ExprToken t = this.packToken(id, lexValue, rowCount, columnCount);
			if ( t.isWildcard() && firstWildcard == null ) {
				firstWildcard = (WildcardExprToken)t;
			}
			tokens.add(t);
			
			id = lex.next();
		}
		
		if ( firstWildcard != null ) {
			int rowSize = firstWildcard.getRowSize();
			int columnSize = firstWildcard.getColumnSize();
			for ( int i = 0; i<columnSize; ++i ) {
				for ( int j = 0; j<rowSize; ++j ) {
					StringBuilder sb = new StringBuilder();
					Iterator<ExprToken> it = tokens.iterator();
					ExprToken et = null;
					while ( it.hasNext() ) {
						et = it.next();
						if ( et.isWildcard() ) {
							WildcardExprToken wet = (WildcardExprToken)et;
							int column = wet.getColumn(i);
							int row = wet.getRow(j);
							sb.append(TokenIDUtil.toColumnID(column));
							sb.append(Integer.toString(row));
						} else {
							sb.append(et.getLexValue());
						}
					}
					String tmp = sb.toString();
					int pos = tmp.indexOf('=');
					String left = tmp.substring(0, pos);
					String right = tmp.substring(pos + 1);
					MetaGridCell metaCell = metaForm.metaGridCellByKey(left);
					if ( metaCell != null ) {
						metaCell.ensureDataBinding().setDefaultFormulaValue(right);
					}
				}
			}
		}
	}
	
	private ExprToken packToken(int id, String lexValue, int rowCount, int columnCount) {
		ExprToken rtn = null;
		boolean isWildcard = id == LexDef.ID && lexValue.charAt(0) == '[';
		if ( isWildcard ) {
			WildcardExprToken wet = new WildcardExprToken(id, lexValue);
			// [A][1]
			int firstPos = lexValue.indexOf(']');
			String columnDef = lexValue.substring(1, firstPos);
			int length = lexValue.length();
			String rowDef = lexValue.substring(firstPos + 2, length - 1);
			
			// 处理列通配
			String[] cv = columnDef.split(",");
			for ( int i = 0, size = cv.length; i<size; ++i ) {
				String s = cv[i];
				// [A,A~D,*]
				if ( s.equals("*") ) {
					int last = wet.findLastColumn();
					if ( last == -1 ) {
						for ( int j = 1; j<=columnCount; ++j ) {
							wet.addColumn(j);
						}
					} else {
						for ( int j = last + 1; j<=columnCount; ++j ) {
							wet.addColumn(j);
						}
					}
				} else {
					int pos = s.indexOf('~');
					if ( pos > 0 ) {
						String s1 = s.substring(0, pos);
						String s2 = s.substring(pos + 1);
						int begin = TokenIDUtil.toColumnIndex(s1);
						int end = -1;
						if ( s2.equals("*") ) {
							end = columnCount;
						} else {
							end = TokenIDUtil.toColumnIndex(s2);
						}
						for ( int j = begin; j<=end; ++j ) {
							wet.addColumn(j);
						}
					} else {
						wet.addColumn(TokenIDUtil.toColumnIndex(s));
					}
				}
			}
			
			// 处理行通配
			String[] rv = rowDef.split(",");
			for ( int i = 0, size = rv.length; i<size; ++i ) {
				// [1,1~4,*]
				String s = rv[i];
				if ( s.equals("*") ) {
					int last = wet.findLastRow();
					if ( last == -1 ) {
						for ( int j = 1; j<=rowCount; ++j ) {
							wet.addRow(j);
						}
					} else {
						for ( int j = last + 1; j<=rowCount; ++j ) {
							wet.addRow(j);
						}
					}
				} else {
					int pos = s.indexOf('~');
					if ( pos > 0 ) {
						String s1 = s.substring(0, pos);
						String s2 = s.substring(pos + 1);
						int begin = Integer.parseInt(s1);
						int end = -1;
						if ( s2.equals("*") ) {
							end = rowCount;
						} else {
							end = Integer.parseInt(s2);
						}
						for ( int j = begin; j<=end; ++j ) {
							wet.addRow(j);
						}
					} else {
						wet.addRow(Integer.parseInt(s));
					}
				}
			}
			
			rtn = wet;
		} else {
			rtn = new ExprToken(id, lexValue);
		}
		return rtn;
	}
}
