package com.bokesoft.yes.meta.process;

import java.util.HashMap;
import java.util.Iterator;

import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.meta.common.MetaVar;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaEmbedTable;
import com.bokesoft.yigo.meta.dataobject.MetaEmbedTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.component.MetaEmbedVarCollection;

public class MetaDataObjectTemplateProcess {
	private IMetaFactory metaFactory = null;
	private MetaDataObject dataObject = null;
	public MetaDataObjectTemplateProcess(IMetaFactory metaFactory, MetaDataObject dataObject) {
		this.metaFactory = metaFactory;
		this.dataObject = dataObject;
	}
	
	public void process() throws Throwable {
		if ( dataObject.getPrimaryType() == DataObjectPrimaryType.TEMPLATE ) {
			return;
		}
		MetaEmbedTableCollection embedTables = dataObject.getEmbedTables();
		if ( embedTables != null ) {
			Iterator<MetaEmbedTable> it = embedTables.iterator();
			MetaEmbedTable embedTable = null;
			while ( it.hasNext() ) {
				embedTable = it.next();
				String sourceObjectKey = embedTable.getObjectKey();
				String sourceTableKeys = embedTable.getTableKeys();
				
				HashMap<String, Object> varValues = new HashMap<String, Object>();
				MetaEmbedVarCollection vars = embedTable.getVars();
				Iterator<MetaVar> itVar = vars.iterator();
				MetaVar var = null;
				while ( itVar.hasNext() ) {
					var = itVar.next();
					varValues.put(var.getKey(), var.getValue());
				}
				MetaDataObject sourceDataObject = metaFactory.getDataObject(sourceObjectKey);
				MetaDataObjectTemplateUtil util = new MetaDataObjectTemplateUtil(sourceDataObject,
						this.dataObject, sourceTableKeys, varValues);
				util.replace();
			}
		}
	}
}
