package com.bokesoft.yes.meta.persist.dom.xml.node;

import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNodeDefine;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class XmlTree {
	private TagNode root = null;

	public XmlTree() {
	}

	public XmlTree(TagNode root) {
		this.root = root;
	}

	public TagNode getRoot() {
		return this.root;
	}

	public void setRoot(TagNode root) {
		this.root = root;
	}

	public void addPreComment(List<AbstractNode> comments) {
		root.addPreComment(comments);
	}

	public void addLastComment(List<AbstractNode> comments) {
		root.addLastComment(comments);
	}

	private List<AbstractNode> allNodeWithCommnet= new Vector<AbstractNode>();
	private HashMap<String, AbstractNode> mapNodes = new HashMap<String, AbstractNode>();

	public void updateMap() {
		List<AbstractNode> commentList= new ArrayList<AbstractNode>();
		updateMap(root, commentList);
	}

	private void updateMap(TagNode tagNode, List<AbstractNode> commentList) {
		if (tagNode == null) {
			return;
		}
		tagNode.addPreComment(commentList);
		recordNodeWithComment(commentList, tagNode);
		commentList.clear();

		if (tagNode.getPrimaryKey() != null) {
			String parentPrimaryKey = "";
			TagNode parent = tagNode.getParent();
			parentPrimaryKey = getParentPrimaryKey(parentPrimaryKey, parent);
			mapNodes.put(parentPrimaryKey + "->" + tagNode.getPrimaryKey(), tagNode);
		}
		List<AbstractNode> children = tagNode.getChildren();
		AbstractNode node = null;
		AbstractNode tmpTagNode = null;
		int size = children.size();
		for (int n = 0; n < size; n++) {
			node = children.get(n);
			if (node instanceof TagNode) {
				updateMap((TagNode) node, commentList);
				tmpTagNode = node;
			} else if (node instanceof CommentNode) {
				commentList.add(node);
			} else if (node instanceof CDataNode) {
				node.addPreComment(commentList);
				recordNodeWithComment(commentList, node);
				commentList.clear();
				tmpTagNode = node;
			}
		}
		if (tmpTagNode != null) {
			tmpTagNode.addLastComment(commentList);
			recordNodeWithComment(commentList, tmpTagNode);
			commentList.clear();
		}
	}
	/**
	 * 获取父节点Key
	 * @param parent
	 * @param parentPrimaryKey
	 * @return
	 */
	private String getParentPrimaryKey(String parentPrimaryKey, TagNode parent) {
		if (parent != null) {
			String attrKey = DefaultNodeDefine.getInstance().getPrimaryKey(parent.getTagName());
			String primaryValue = parent.getAttributes().get(attrKey);
			if (StringUtils.isEmpty(primaryValue)){
				parentPrimaryKey = parentPrimaryKey.concat(getParentPrimaryKey(parentPrimaryKey, parent.getParent()));
			}else {
				parentPrimaryKey = parent.getPrimaryKey();
			}
		}
		return parentPrimaryKey;
	}

	/**
	 * 记录含有注释的节点
	 *
	 * @param commnetList
	 * @param node
	 */
	private void recordNodeWithComment(List<AbstractNode> commnetList, AbstractNode node) {
		if (commnetList.size() > 0 && !allNodeWithCommnet.contains(node)) {
			allNodeWithCommnet.add(node);
		}
	}

	/**
	 * 获取文档中的所有注释
	 *
	 * @return
	 */
	public List<AbstractNode> getNodesWithComment() {
		return allNodeWithCommnet;
	}

	public TagNode getTagNode(String key) {
		return (TagNode) mapNodes.get(key);
	}

	public boolean containKey(String key) {
		return mapNodes.containsKey(key);
	}
}