package com.bokesoft.yes.meta.persist.dom.xml.defaultnode;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.bokesoft.yes.common.util.StringUtil;

public class DefaultNodeDefine {
	
	private final static String ATTRIBUTE_ATTRS = "Attrs";
	
	private final static String ATTRIBUTE_PRIMARYKEY = "PrimaryKey";
	
	private final static String ATTRIBUTE_ISSINGLE = "IsSingle";
	
	public final static String NODE_COMMENT = "!-- -->";
	public final static String NODE_CDATA = "![CDATA[ ]]>";
	
	private DefaultNodeCollection nodeCollection = new DefaultNodeCollection();
	
	private DefaultNodeDefine() {
		load();
		nodeCollection.setNode(NODE_COMMENT, new DefaultNode(NODE_COMMENT, true));
		nodeCollection.setNode(NODE_CDATA, new DefaultNode(NODE_CDATA, true));
	}
	
	private void load() {
		InputStream in = null;
		try {
			in = DefaultNodeDefine.class.getResourceAsStream("XmlNodeDefine.xml");
			Document document = null;
			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			document = builder.parse(in);
			Element rootElement = document.getDocumentElement();
			trans(rootElement, "", "");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (in != null) {
					in.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
	public DefaultNode getDefaultNode(String tagName) {
		return nodeCollection.getNode(tagName);
	}
	
	public String getPrimaryKey(String tagName) {
		DefaultNode node = getDefaultNode(tagName);
		if (node != null) {
			return node.getPrimaryKey();
		}
		return "Key";
	}
	
	private void trans(Element elem, String sParentAttrs, String primaryKey) {
		primaryKey = StringUtil.isEmptyStr(elem.getAttribute(ATTRIBUTE_PRIMARYKEY)) ? primaryKey : elem.getAttribute(ATTRIBUTE_PRIMARYKEY);
		String allAttrs = getAllAttrs(elem,sParentAttrs);
		if (elem.hasChildNodes()) {
			NodeList childNodes = elem.getChildNodes();
			int len = childNodes.getLength();
			for (int i = 0; i < len; i++) {
				Node childNode = childNodes.item(i);
				if (childNode instanceof Element) {
					trans((Element) childNode, allAttrs, primaryKey);
				}
			}
		} else {
			createDefaultNode(elem, allAttrs, primaryKey);
		}

	}
	
	private void createDefaultNode(Element elem, String sParentAttrs, String primaryKey) {
		primaryKey = StringUtil.isEmptyStr(elem.getAttribute(ATTRIBUTE_PRIMARYKEY)) ? primaryKey : elem.getAttribute(ATTRIBUTE_PRIMARYKEY);
		String allAttrs = getAllAttrs(elem, sParentAttrs);
		String[] attrs = allAttrs.split(",");
		String tagName = elem.getTagName();
		DefaultNode node = new DefaultNode(tagName);
		node.setPrimaryKey(primaryKey);
		for (String attr : attrs) {
			node.addNode(new LinkedData(attr));
		}
		boolean isSingle = StringUtil.isEmptyStr(elem.getAttribute(ATTRIBUTE_ISSINGLE)) ? false : Boolean.valueOf(elem.getAttribute(ATTRIBUTE_ISSINGLE));
		node.setSingle(isSingle);
		nodeCollection.setNode(tagName, node);
	}
	
	private String getAllAttrs(Element elem, String sParentAttrs) {
		String allAttrs = "";
		String attrs = elem.getAttribute(ATTRIBUTE_ATTRS);
		if (StringUtil.isEmptyStr(sParentAttrs) && StringUtil.isEmptyStr(attrs)) {
			allAttrs = "";
		} else if(StringUtil.isEmptyStr(sParentAttrs)) {
			allAttrs = attrs;
		} else if(StringUtil.isEmptyStr(attrs)) {
			allAttrs = sParentAttrs;
		} else {
			allAttrs = sParentAttrs + "," + attrs;
		}
		return allAttrs;
	}
	
	private static DefaultNodeDefine instance = null;
	
	public static synchronized DefaultNodeDefine getInstance() {
		if (instance == null) {
			instance = new DefaultNodeDefine();
		}
		return instance;
	}

	public String[] getPopupArray(List<String> filters) {
		return nodeCollection.getNodenames();
	}
}
