package com.bokesoft.yes.meta.persist.dom.taskflow;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.taskflow.node.MetaStyle;

public class MetaStyleAction extends BaseDomAction<MetaStyle> {

	@Override
	public void load(Document document, Element element, MetaStyle meta, int runType) {
		meta.setWidth(DomHelper.readAttr(element, MetaConstants.STYLE_WIDTH, 0));
		meta.setHeight(DomHelper.readAttr(element, MetaConstants.STYLE_HEIGHT, 0));
		meta.setX(DomHelper.readAttr(element, MetaConstants.STYLE_X, -1));
		meta.setY(DomHelper.readAttr(element, MetaConstants.STYLE_Y, -1));
	}

	@Override
	public void save(Document document, Element element, MetaStyle meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.STYLE_WIDTH, meta.getWidth(), 0);
		DomHelper.writeAttr(element, MetaConstants.STYLE_HEIGHT, meta.getHeight(), 0);
		DomHelper.writeAttr(element, MetaConstants.STYLE_X, meta.getX(), -1);
		DomHelper.writeAttr(element, MetaConstants.STYLE_Y, meta.getY(), -1);
	}
	
}
