package com.bokesoft.yes.meta.persist.dom.taskflow;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.taskflow.node.MetaState;

public class MetaStateAction extends MetaNodeAction<MetaState> {
	
	@Override
	public void load(Document document, Element element, MetaState meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setStatus(DomHelper.readAttr(element, MetaConstants.STATE_STATUS, ""));
	}

	@Override
	public void save(Document document, Element element, MetaState meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.STATE_STATUS, meta.getStatus(), "");
	}

}
