package com.bokesoft.yes.meta.persist.dom.solution;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaSecurityProvider;

public class MetaSecurityProviderAction extends BaseDomAction<MetaSecurityProvider>{

	@Override
	public void load(Document document, Element element,
			MetaSecurityProvider meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_VERB, ""));
		meta.setProvider(DomHelper.readAttr(element, MetaConstants.SECURITY_PROVIDER, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaSecurityProvider meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_VERB, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SECURITY_PROVIDER, meta.getProvider(), "");
	}

}
