package com.bokesoft.yes.meta.persist.dom.solution;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.FormTarget;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.solution.MetaPreLoadItem;

public class MetaPreLoadItemAction extends BaseDomAction<MetaPreLoadItem>{

	@Override
	public void load(Document document, Element element, MetaPreLoadItem meta,
			int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setEntryPath(DomHelper.readAttr(element, MetaConstants.COMMON_ENTRYPATH, ""));
		meta.setCondition(DomHelper.readAttr(element, MetaConstants.COMMON_CONDITION, ""));
		meta.setClose(DomHelper.readAttr(element, MetaConstants.COMMON_CLOSE, true));
		meta.setTarget(FormTarget.parse(DomHelper.readAttr(element, MetaConstants.ENTRY_TARGET, FormTarget.STR_NEWTAB)));
	}

	@Override
	public void save(Document document, Element element, MetaPreLoadItem meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ENTRYPATH, meta.getEntryPath(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CONDITION, meta.getCondition(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CLOSE, meta.isClose(), true);
		DomHelper.writeAttr(element, MetaConstants.ENTRY_TARGET, FormTarget.toString(meta.getTarget()), FormTarget.STR_NEWTAB);
	}

}
