package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.setting.MetaSession;

public class MetaSessionAction extends BaseDomAction<MetaSession> {

	@Override
	public void load(Document document, Element element, MetaSession meta, int runType) {
		meta.setTimeout(DomHelper.readAttr(element, MetaConstants.SESSION_TIMEOUT, 3600));
		meta.setMobileTimeout(DomHelper.readAttr(element, MetaConstants.SESSION_MOBILETIMEOUT, 0));
		meta.setEnableLock(DomHelper.readAttr(element, MetaConstants.SESSION_ENABLELOCK, false));
		meta.setMaxLoginCount(DomHelper.readAttr(element, MetaConstants.SESSION_MAXLOGINCOUNT, -1));
		meta.setSessionParaKey(DomHelper.readAttr(element, MetaConstants.SESSION_PARAKEY, ""));
		meta.setSessionParaTitle(DomHelper.readAttr(element, MetaConstants.SESSION_PARATITLE, ""));
		meta.setSessionParaItemsProvider(DomHelper.readAttr(element, MetaConstants.SESSION_PARAITEMS_PROVIDER, ""));
		meta.setSessionParaProcess(DomHelper.readAttr(element, MetaConstants.SESSION_PARA_PROCESS, ""));
		meta.setSessionParaAsCluster(DomHelper.readAttr(element, MetaConstants.SESSION_PARA_ASCLUSTER, false));
		meta.setAuthenticateProvider(DomHelper.readAttr(element, MetaConstants.SESSION_AUTHENTICATE_PROVIDER, ""));
		meta.setGuestAuthenticateProvider(DomHelper.readAttr(element, MetaConstants.SESSION_GUEST_AUTHENTICATE_PROVIDER, ""));
		meta.setAccountLockoutDuration(DomHelper.readAttr(element, MetaConstants.ACCOUNT_LOCKOUT_DURATION, 0));
		meta.setAccountLockoutThreshold(DomHelper.readAttr(element, MetaConstants.ACCOUNT_LOCKOUT_THRESHOLD, 0));
		meta.setUserLockInfoIsPersist(DomHelper.readBool(element, MetaConstants.USER_LOCK_INFO_IS_PERSIST, false));
	}

	@Override
	public void save(Document document, Element element, MetaSession meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.SESSION_TIMEOUT, meta.getTimeout(), 3600);
		DomHelper.writeAttr(element, MetaConstants.SESSION_MOBILETIMEOUT, meta.getMobileTimeout(), 0);
		DomHelper.writeAttr(element, MetaConstants.SESSION_ENABLELOCK, meta.isEnableLock(), false);
		DomHelper.writeAttr(element, MetaConstants.SESSION_MAXLOGINCOUNT, meta.getMaxLoginCount(), -1);
		DomHelper.writeAttr(element, MetaConstants.SESSION_PARAKEY, meta.getSessionParaKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SESSION_PARATITLE, meta.getSessionParaTitle(), "");
		DomHelper.writeAttr(element, MetaConstants.SESSION_PARAITEMS_PROVIDER, meta.getSessionParaItemsProvider(), "");
		DomHelper.writeAttr(element, MetaConstants.SESSION_PARA_PROCESS, meta.getSessionParaProcess(), "");
		DomHelper.writeAttr(element, MetaConstants.SESSION_PARA_ASCLUSTER, meta.isSessionParaAsCluster(), false);
		DomHelper.writeAttr(element, MetaConstants.SESSION_AUTHENTICATE_PROVIDER, meta.getAuthenticateProvider(), "");
		DomHelper.writeAttr(element, MetaConstants.SESSION_GUEST_AUTHENTICATE_PROVIDER, meta.getGuestAuthenticateProvider(), "");
		DomHelper.writeAttr(element, MetaConstants.ACCOUNT_LOCKOUT_DURATION, meta.getAccountLockoutDuration(), 0);
		DomHelper.writeAttr(element, MetaConstants.ACCOUNT_LOCKOUT_THRESHOLD, meta.getAccountLockoutThreshold(), 0);
		DomHelper.writeAttr(element, MetaConstants.USER_LOCK_INFO_IS_PERSIST, meta.getUserLockInfoIsPersist(), false);
	}

}
