package com.bokesoft.yes.meta.persist.dom.relation.path.check;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.path.check.MetaService;
import com.bokesoft.yigo.meta.relation.MetaRelationConstants;

public class MetaServiceAction extends BaseDomAction<MetaService> {

	@Override
	public void load(Document document, Element element, MetaService meta, int runType) {
		meta.setBlacklist(DomHelper.readAttr(element, MetaRelationConstants.BLACKLIST, false));
		meta.setServiceName(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));

	}

	@Override
	public void save(Document document, Element element, MetaService meta, int runType) {
		DomHelper.writeAttr(element, MetaRelationConstants.BLACKLIST, meta.isBlacklist(), false);
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getServiceName(), "");
	}
}
