package com.bokesoft.yes.meta.persist.dom.relation.path;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.path.line.MetaRelationItem;
import com.bokesoft.yigo.meta.relation.MetaRelationConstants;

public class MetaRelationItemAction extends BaseDomAction<MetaRelationItem> {

	@Override
	public void load(Document document, Element element, MetaRelationItem meta, int runType) {
		meta.setTableKey(DomHelper.readAttr(element, MetaRelationConstants.RELATION_TABLEKEY, ""));
		meta.setColumnKey(DomHelper.readAttr(element, MetaRelationConstants.RELATION_COLUMNKEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setTgtnodeID(new Integer(DomHelper.readAttr(element, MetaRelationConstants.RELATION_TGTNODEID, 1)));
		meta.setNextColumn(DomHelper.readAttr(element, MetaRelationConstants.RELATION_NEXTCOLUMN, ""));
		meta.setExplandSQL(DomHelper.readAttr(element, MetaRelationConstants.RELATION_EXPLANDSQL, ""));
		meta.setID(new Integer(DomHelper.readAttr(element, MetaRelationConstants.RELATION_ID, 1)));
	}

	@Override
	public void save(Document document, Element element, MetaRelationItem meta, int runType) {
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_COLUMNKEY, meta.getColumnKey(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_TGTNODEID, meta.getTgtnodeID(), 1);
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_NEXTCOLUMN, meta.getNextColumn(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_EXPLANDSQL, meta.getExplandSQL(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_ID, meta.getID(), 1);
	}

}
