package com.bokesoft.yes.meta.persist.dom.relation.path;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.path.line.MetaRelationCheckArg;
import com.bokesoft.yigo.meta.relation.MetaRelationConstants;

public class MetaRelationCheckArgAction extends BaseDomAction<MetaRelationCheckArg> {

	@Override
	public void load(Document document, Element element, MetaRelationCheckArg meta, int runType) {
		meta.setParaindex(DomHelper.readAttr(element, MetaRelationConstants.RELATION_PARASINDEX, -1));
		meta.setErrorInfo(DomHelper.readAttr(element, MetaRelationConstants.RELATION_ERROR_INFO, ""));
	}

	@Override
	public void save(Document document, Element element, MetaRelationCheckArg meta, int runType) {
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_PARASINDEX, meta.getParaindex(), -1);
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_ERROR_INFO, meta.getErrorInfo(), "");
	}
}
