package com.bokesoft.yes.meta.persist.dom.permission.filter;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.MappingRelationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.permission.filter.MetaMappingFilter;

public class MetaMappingFilterAction extends BaseDomAction<MetaMappingFilter> {

	@Override
	public void load(Document document, Element element, MetaMappingFilter meta, int runType) {
		meta.setSourceMapKey(DomHelper.readAttr(element, MetaFilterConstants.SOURCE_MAP_KEY, ""));
		meta.setTargetMapKey(DomHelper.readAttr(element, MetaFilterConstants.TARGET_MAP_KEY, ""));
		meta.setRelationType(MappingRelationType.parse(DomHelper.readAttr(element, MetaFilterConstants.RELATION_TYPE, MappingRelationType.STR_CONTAIN)));
	}

	@Override
	public void save(Document document, Element element, MetaMappingFilter meta, int runType) {
		DomHelper.writeAttr(element, MetaFilterConstants.SOURCE_MAP_KEY, meta.getSourceMapKey(), "");
		DomHelper.writeAttr(element, MetaFilterConstants.TARGET_MAP_KEY, meta.getTargetMapKey(), "");
		DomHelper.writeAttr(element, MetaFilterConstants.RELATION_TYPE, MappingRelationType.toString(meta.getRelationType()), MappingRelationType.STR_CONTAIN);
	}

}
