package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexGridLayout;

public class MetaFlexGridLayoutAction extends MetaComponentLayoutAction {
	@Override
	public void load(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.load(document, element, meta, runType);
		MetaFlexGridLayout metaFlexGridLayout = (MetaFlexGridLayout)meta;
		metaFlexGridLayout.setColumnCount(DomHelper.readAttr(element, MetaConstants.FLEXGRIDLAYOUT_COLUMNCOUNT, 1));
		metaFlexGridLayout.setRowGap(DomHelper.readAttr(element, MetaConstants.FLEXGRIDLAYOUT_ROWGAP, 0));
		metaFlexGridLayout.setColumnGap(DomHelper.readAttr(element, MetaConstants.FLEXGRIDLAYOUT_COLUMNGAP, 0));
		metaFlexGridLayout.setRowHeight(DomHelper.readAttr(element, MetaConstants.FLEXGRIDLAYOUT_ROWHEIGHT, 0));
	}

	@Override
	public void save(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.save(document, element, meta, runType);
		MetaFlexGridLayout metaFlexGridLayout = (MetaFlexGridLayout)meta;
		DomHelper.writeAttr(element, MetaConstants.FLEXGRIDLAYOUT_COLUMNCOUNT, metaFlexGridLayout.getColumnCount(), 1);
		DomHelper.writeAttr(element, MetaConstants.FLEXGRIDLAYOUT_ROWGAP, metaFlexGridLayout.getRowGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.FLEXGRIDLAYOUT_COLUMNGAP, metaFlexGridLayout.getColumnGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.FLEXGRIDLAYOUT_ROWHEIGHT, metaFlexGridLayout.getRowHeight(), 0);
	}
}
