package com.bokesoft.yes.meta.persist.dom.form.component.panel.gridpanel;
/*
 *文件名: MetaHandleAction
 *创建者: zhangk
 *创建时间:2022/9/10 20:45
 */

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaHandle;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaHandleEnum;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetaHandleAction extends BaseDomAction<MetaHandle> {

	@Override
	public void load(Document document, Element element, MetaHandle meta, int runType) {
		meta.setType(MetaHandleEnum.getTypeByName(DomHelper.readAttr(element, MetaConstants.HANDLE_TYPE, MetaHandleEnum.DEFAULT.getName())));
		meta.setX(DomHelper.readAttr(element, MetaConstants.HANDLE_X, -1));
		meta.setY(DomHelper.readAttr(element, MetaConstants.HANDLE_Y, -1));
		meta.setxSpan(DomHelper.readAttr(element, MetaConstants.HANDLE_X_SPAN, -1));
		meta.setySpan(DomHelper.readAttr(element, MetaConstants.HANDLE_Y_SPAN, -1));
		meta.setExpandStyleClass(DomHelper.readAttr(element, MetaConstants.EXPAND_STYLE_CLASS, ""));
		meta.setCollapseStyleClass(DomHelper.readAttr(element, MetaConstants.COLLAPSE_STYLE_CLASS, ""));

	}

	@Override
	public void save(Document document, Element element, MetaHandle meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.HANDLE_TYPE, MetaHandleEnum.getNameByType(meta.getType()), MetaHandleEnum.DEFAULT.getName());
		DomHelper.writeAttr(element, MetaConstants.HANDLE_X, meta.getX(), -1);
		DomHelper.writeAttr(element, MetaConstants.HANDLE_Y, meta.getY(), -1);
		DomHelper.writeAttr(element, MetaConstants.HANDLE_X_SPAN, meta.getxSpan(), -1);
		DomHelper.writeAttr(element, MetaConstants.HANDLE_Y_SPAN, meta.getySpan(), -1);
		DomHelper.writeAttr(element, MetaConstants.EXPAND_STYLE_CLASS, meta.getExpandStyleClass(), "");
		DomHelper.writeAttr(element, MetaConstants.COLLAPSE_STYLE_CLASS, meta.getCollapseStyleClass(), "");
	}
}
