package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ColumnType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;


public class MetaGridColumnAction extends BaseDomAction<MetaGridColumn> {
	@Override
	public void load(Document document, Element element, MetaGridColumn meta,
			int runType) {
		String key = DomHelper.readAttr(element, MetaConstants.COMMON_KEY, "");
		meta.setKey(key);
		meta.setOldKey(key);
		meta.setMetaKey(key);
		
		meta.setWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMMON_WIDTH,"")));
		meta.setSortable(DomHelper.readBool(element, MetaConstants.SORTABLE, null));
		
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, ""));
		
		meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, ""));
		
		meta.setEnableDependency(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, ""));
		
		meta.setVisibleDependency(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, ""));
		meta.setColumnType(ColumnType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_TYPE, ColumnType.STR_Fix)));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setCaptionFull(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_FULL, ""));
		meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, ""));
		meta.setCaptionEnFull(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN_FULL, ""));
		meta.setFormulaCaption(DomHelper.readAttr(element, MetaConstants.FORMULA_CAPTION, ""));
		meta.setAutoCaption(DomHelper.readAttr(element, MetaConstants.AUTO_CAPTION, false));
		meta.setFrozen(DomHelper.readAttr(element, MetaConstants.COMMON_FREEZE, false));
		meta.setFixed(DomHelper.readAttr(element, MetaConstants.COMMON_FIXED, ""));
        meta.setMetaCellImage(DomHelper.readAttr(element, MetaConstants.COMMON_METACELLIMAGE, ""));
		meta.setImage(DomHelper.readAttr(element, MetaConstants.IMAGE, ""));
		meta.setIsVestDeleteCol(DomHelper.readAttr(element, MetaConstants.COMMON_ISVESTDELETECOL, false));
		meta.setSumFormula(DomHelper.readAttr(element, MetaConstants.SUMFORMULA, ""));
		meta.setGroupSumFormula(DomHelper.readAttr(element, MetaConstants.GROUPSUMFORMULA, ""));
	}

	@Override
	public void save(Document document, Element element, MetaGridColumn meta,
			int runType) {
		DefSize width = meta.getWidth();
		if ( width != null ) {
			DomHelper.writeAttr(element, MetaConstants.COMMON_WIDTH, width.toString(), "");
		}
		DomHelper.writeAttr(element, MetaConstants.SORTABLE, meta.getSortable(), false);
		
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE, meta.getVisible(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE, meta.getEnable(), "");

		DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, meta.getEnableDependency(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, meta.getVisibleDependency(), "");
		
		DomHelper.writeAttr(element, MetaConstants.COLUMN_TYPE, ColumnType.toString(meta.getColumnType()), ColumnType.STR_Fix);
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(),"");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_FULL, meta.getCaptionFull(),"");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_EN, meta.getCaptionEn(),"");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_EN_FULL, meta.getCaptionEnFull(),"");
		DomHelper.writeAttr(element, MetaConstants.FORMULA_CAPTION, meta.getFormulaCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.AUTO_CAPTION, meta.isAutoCaption(), false);
		DomHelper.writeAttr(element, MetaConstants.COMMON_FREEZE, meta.isFrozen(), false);
		DomHelper.writeAttr(element, MetaConstants.COMMON_FIXED, meta.getFixed(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ISVESTDELETECOL, meta.isVestDeleted(), false);
        DomHelper.writeAttr(element, MetaConstants.COMMON_METACELLIMAGE, meta.getMetaCellImage(), "");
		DomHelper.writeAttr(element,  MetaConstants.IMAGE, meta.getImage(), "");
		DomHelper.writeAttr(element,  MetaConstants.SUMFORMULA, meta.getSumFormula(), "");
		DomHelper.writeAttr(element,  MetaConstants.GROUPSUMFORMULA, meta.getGroupSumFormula(), "");
	}

}
